/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.service.connector;

import java.io.IOException;
import java.util.Hashtable;
import org.apache.tomcat.core.RequestImpl;
import org.apache.tomcat.service.connector.ConnectorServletIS;
import org.apache.tomcat.service.connector.MsgBuffer;
import org.apache.tomcat.service.connector.MsgConnector;

public class ConnectorRequest
extends RequestImpl {
    MsgConnector con;
    Hashtable env_vars;

    public ConnectorRequest(MsgConnector con) {
        this.con = con;
    }

    protected int decodeRequest(MsgBuffer msg) throws IOException {
        String hostHeader;
        this.env_vars = new Hashtable();
        int envCount = msg.getInt();
        int i2 = 0;
        while (i2 < envCount) {
            String n2 = msg.getString();
            String v2 = msg.getString();
            this.env_vars.put(n2, v2);
            ++i2;
        }
        int hCount = msg.getInt();
        int i3 = 0;
        while (i3 < hCount) {
            String n3 = msg.getString();
            String v3 = msg.getString();
            this.headers.putHeader(n3.toLowerCase(), v3);
            ++i3;
        }
        byte[] initialBodyChunk = new byte[msg.getMaxLen()];
        int len = msg.getBytes(initialBodyChunk);
        ConnectorServletIS in = new ConnectorServletIS(this.con, initialBodyChunk, len);
        this.in = in;
        this.method = (String)this.env_vars.get("REQUEST_METHOD");
        this.protocol = (String)this.env_vars.get("SERVER_PROTOCOL");
        this.requestURI = (String)this.env_vars.get("REQUEST_URI");
        this.queryString = (String)this.env_vars.get("QUERY_STRING");
        if (this.queryString != null && !"".equals(this.queryString)) {
            this.processFormData(this.queryString);
        }
        if (this.requestURI == null) {
            this.requestURI = "xxx";
        }
        if (this.requestURI.indexOf("?") > -1) {
            this.requestURI = this.requestURI.substring(0, this.requestURI.indexOf("?"));
        }
        if ((hostHeader = this.getHeader("host")) != null) {
            int i4 = hostHeader.indexOf(58);
            if (i4 > -1) {
                hostHeader = hostHeader.substring(0, i4);
            }
            this.setServerName(hostHeader);
        } else {
            this.setServerName("localhost");
        }
        this.contentLength = this.headers.getIntHeader("content-length");
        this.contentType = this.headers.getHeader("content-type");
        this.charEncoding = this.getCharsetFromContentType(this.contentType);
        String sport = (String)this.env_vars.get("SERVER_PORT");
        if (sport == null) {
            sport = "80";
        }
        this.serverPort = new Integer(sport);
        this.remoteAddr = (String)this.env_vars.get("REMOTE_ADDR");
        this.remoteHost = (String)this.env_vars.get("REMOTE_ADDR");
        this.processCookies();
        return 0;
    }

    public void recycle() {
        super.recycle();
    }
}

