/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.service.http;

import java.io.IOException;
import java.io.InputStream;
import org.apache.tomcat.core.RequestImpl;
import org.apache.tomcat.service.http.HttpServletIS;

public class HttpRequest
extends RequestImpl {
    public void processRequestLine(String line) {
        String s2;
        String buffer = line.trim();
        int firstDelim = buffer.indexOf(32);
        int lastDelim = buffer.lastIndexOf(32);
        if (firstDelim == -1 && lastDelim == -1 && buffer.trim().length() > 0) {
            firstDelim = buffer.trim().length();
            lastDelim = buffer.trim().length();
        }
        if (firstDelim != lastDelim && (s2 = buffer.substring(firstDelim, lastDelim)).trim().length() == 0) {
            firstDelim = lastDelim;
        }
        if (firstDelim != lastDelim) {
            this.method = buffer.substring(0, firstDelim).trim();
            this.protocol = buffer.substring(lastDelim + 1).trim();
            this.requestURI = buffer.substring(firstDelim + 1, lastDelim).trim();
        } else if (firstDelim != -1 && lastDelim != -1) {
            this.method = buffer.substring(0, firstDelim).trim();
            this.protocol = null;
            if (lastDelim < buffer.length()) {
                this.requestURI = buffer.substring(lastDelim + 1).trim();
            }
        }
        if (this.protocol != null && !this.protocol.toLowerCase().startsWith("http/")) {
            this.requestURI = String.valueOf(this.requestURI) + " " + this.protocol;
            this.protocol = null;
        }
        int requestErrorCode = 0;
        try {
            int len = line.length();
            if (len < 2) {
                requestErrorCode = 400;
            } else if (line.charAt(len - 1) != '\n') {
                requestErrorCode = 414;
                this.protocol = "HTTP/1.0";
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {}
        if (requestErrorCode == 0 && (this.requestURI == null || this.requestURI.indexOf(32) > -1 || this.requestURI.indexOf(47) != 0)) {
            requestErrorCode = 400;
        }
        if (requestErrorCode != 0) {
            try {
                this.response.sendError(requestErrorCode);
            }
            catch (IOException iOException) {}
            return;
        }
        if (this.requestURI.indexOf("?") > -1) {
            this.queryString = this.requestURI.substring(this.requestURI.indexOf("?") + 1, this.requestURI.length());
            this.processFormData(this.queryString);
            this.requestURI = this.requestURI.substring(0, this.requestURI.indexOf("?"));
        }
    }

    protected int readRequest(InputStream is) throws IOException {
        HttpServletIS in = new HttpServletIS(is);
        this.in = in;
        String line = in.readLine();
        if (line == null) {
            return -1;
        }
        this.processRequestLine(line);
        this.headers.read(in);
        return 0;
    }

    public void recycle() {
        super.recycle();
    }
}

