/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.service.http;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.tomcat.core.ResponseImpl;
import org.apache.tomcat.service.http.HttpServletOS;
import org.apache.tomcat.util.HttpDate;
import org.apache.tomcat.util.MimeHeaderField;

public class HttpResponse
extends ResponseImpl {
    OutputStream os;

    public HttpResponse() {
        this.out = new HttpServletOS();
        ((HttpServletOS)this.out).setResponse(this);
    }

    public HttpResponse(OutputStream os) {
        this.out = new HttpServletOS(this, os);
    }

    protected void appendStatus(StringBuffer buf) {
        String statusPhrase = null;
        buf.append("HTTP/1.0 " + this.status);
        if (statusPhrase != null) {
            buf.append(" " + statusPhrase);
        }
        buf.append("\r\n");
    }

    public void endResponse() throws IOException {
    }

    public void recycle() {
        super.recycle();
        this.os = null;
    }

    public void setOutputStream(OutputStream os) {
        this.os = os;
        ((HttpServletOS)this.out).setOutputStream(os);
    }

    public void writeHeaders() throws IOException {
        if (this.omitHeaders) {
            return;
        }
        this.fixHeaders();
        StringBuffer buf = new StringBuffer();
        this.appendStatus(buf);
        HttpDate date = new HttpDate(System.currentTimeMillis());
        buf.append("Date: " + date + "\r\n");
        buf.append("Server: " + this.getServerHeader() + "\r\n");
        if (this.request.getContext() != null) {
            buf.append("Servlet-Engine: " + this.request.getContext().getEngineHeader() + "\r\n");
        }
        if (this.contentLanguage != null) {
            buf.append("Content-Language: " + this.contentLanguage + "\r\n");
        }
        int size = this.headers.size();
        int i2 = 0;
        while (i2 < size) {
            MimeHeaderField h2 = this.headers.getField(i2);
            buf.append(h2).append("\r\n");
            ++i2;
        }
        buf.append("\r\n");
        this.os.write(buf.toString().getBytes());
    }
}

