/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.tomcat.util.Ascii;
import org.apache.tomcat.util.HttpDate;
import org.apache.tomcat.util.StringManager;

public class MessageBytes
extends Ascii {
    private StringManager sm = StringManager.getManager("org.apache.tomcat.util");
    protected byte[] bytes;
    protected int offset;
    protected int length;

    public MessageBytes() {
    }

    public MessageBytes(byte[] b10, int off, int len) {
        this.setBytes(b10, off, len);
    }

    public boolean equals(String s2) {
        byte[] b10 = this.bytes;
        int len = this.length;
        if (b10 == null || len != s2.length()) {
            return false;
        }
        int off = this.offset;
        int i2 = 0;
        while (i2 < len) {
            if (b10[off++] != s2.charAt(i2)) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    public boolean equals(byte[] b10, int off, int len) {
        byte[] b12 = this.bytes;
        if (b12 == null || len != this.length) {
            return false;
        }
        int off1 = this.offset;
        while (len-- > 0) {
            if (b10[off++] == b12[off1++]) continue;
            return false;
        }
        return true;
    }

    public boolean equalsIgnoreCase(String s2) {
        byte[] b10 = this.bytes;
        int len = this.length;
        if (b10 == null || len != s2.length()) {
            return false;
        }
        int off = this.offset;
        int i2 = 0;
        while (i2 < len) {
            if (Ascii.toLower(b10[off++]) != Ascii.toLower((byte)s2.charAt(i2))) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    public boolean equalsIgnoreCase(byte[] b10, int off, int len) {
        byte[] b12 = this.bytes;
        if (b12 == null || len != this.length) {
            return false;
        }
        int off1 = this.offset;
        while (len-- > 0) {
            if (Ascii.toLower(b10[off++]) == Ascii.toLower(b12[off1++])) continue;
            return false;
        }
        return true;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public int getBytes(byte[] buf, int buf_offset) {
        if (this.bytes != null) {
            System.arraycopy(this.bytes, this.offset, buf, buf_offset, this.length);
        }
        return this.length;
    }

    public int getLength() {
        return this.length;
    }

    public int getOffset() {
        return this.offset;
    }

    public boolean isSet() {
        return this.bytes != null;
    }

    public int length() {
        return this.bytes != null ? this.length : 0;
    }

    public void reset() {
        this.bytes = null;
    }

    public void setBytes(byte[] b10, int off, int len) {
        this.bytes = b10;
        this.offset = off;
        this.length = len;
    }

    public boolean startsWith(String s2) {
        byte[] b10 = this.bytes;
        int len = s2.length();
        if (b10 == null || len > this.length) {
            return false;
        }
        int off = this.offset;
        int i2 = 0;
        while (i2 < len) {
            if (b10[off++] != s2.charAt(i2)) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    public long toDate(HttpDate d10) throws IllegalArgumentException {
        if (this.bytes != null) {
            d10.parse(this.bytes, this.offset, this.length);
            return d10.getTime();
        }
        String msg = this.sm.getString("messageBytes.iae", (Object)this.bytes);
        throw new IllegalArgumentException(msg);
    }

    public int toInteger() throws NumberFormatException {
        return Ascii.parseInt(this.bytes, this.offset, this.length);
    }

    public String toString() {
        return this.bytes != null ? new String(this.bytes, this.offset, this.length) : null;
    }

    public void write(OutputStream out) throws IOException {
        if (this.bytes != null) {
            out.write(this.bytes, this.offset, this.length);
        }
    }
}

