/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;

public class URLUtil {
    public static URL resolve(String s2) throws MalformedURLException {
        return URLUtil.resolve(s2, null);
    }

    public static URL resolve(String s2, URL url) throws MalformedURLException {
        URL resolve = null;
        if (s2.indexOf("://") > -1 || s2.indexOf("file:") > -1) {
            resolve = new URL(s2);
        } else if (url != null) {
            resolve = new URL(url, s2);
        } else if (s2.startsWith(File.separator) || s2.startsWith("/") || s2.length() >= 2 && Character.isLetter(s2.charAt(0)) && s2.charAt(1) == ':') {
            String fName = s2;
            try {
                fName = new File(s2).getCanonicalPath();
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (IOException iOException) {}
            resolve = new URL("file", null, fName);
        } else {
            String path = String.valueOf(System.getProperty("user.dir")) + File.separator + s2;
            resolve = new URL("file", null, path);
        }
        if (!resolve.getProtocol().equalsIgnoreCase("war") && (resolve.getFile().toLowerCase().endsWith(".war") || resolve.getFile().toLowerCase().endsWith(".jar"))) {
            URL u2;
            resolve = u2 = new URL("war:" + resolve.toString());
        }
        resolve = new URL(URLUtil.trim(resolve.toString(), ".", ".."));
        resolve = new URL(URLUtil.trim(resolve.toString(), "./"));
        return resolve;
    }

    private static String trim(String s2, String t2) {
        return URLUtil.trim(s2, t2, null);
    }

    private static String trim(String s2, String r2, String t2) {
        while (s2.endsWith(r2) && (t2 == null ? true : s2.endsWith(t2) ^ true)) {
            int i2 = s2.length() - r2.length();
            s2 = s2.substring(0, i2);
        }
        return s2;
    }
}

