/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.rmic;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;

public class IndentingWriter
extends BufferedWriter {
    private boolean beginningOfLine = true;
    private int currentIndent = 0;
    private int indentStep = 4;
    private int tabSize = 8;

    public IndentingWriter(Writer writer) {
        super(writer);
    }

    public IndentingWriter(Writer writer, int n2) {
        this(writer);
        if (this.indentStep < 0) {
            throw new IllegalArgumentException("negative indent step");
        }
        this.indentStep = n2;
    }

    public IndentingWriter(Writer writer, int n2, int n3) {
        this(writer);
        if (this.indentStep < 0) {
            throw new IllegalArgumentException("negative indent step");
        }
        this.indentStep = n2;
        this.tabSize = n3;
    }

    protected void checkWrite() throws IOException {
        if (this.beginningOfLine) {
            this.beginningOfLine = false;
            int n2 = this.currentIndent;
            while (n2 >= this.tabSize) {
                super.write(9);
                n2 -= this.tabSize;
            }
            while (n2 > 0) {
                super.write(32);
                --n2;
            }
        }
    }

    protected void indentIn() {
        this.currentIndent += this.indentStep;
    }

    protected void indentOut() {
        this.currentIndent -= this.indentStep;
        if (this.currentIndent < 0) {
            this.currentIndent = 0;
        }
    }

    public void newLine() throws IOException {
        super.newLine();
        this.beginningOfLine = true;
    }

    public void p(Object object) throws IOException {
        this.write(object.toString());
    }

    public void p(String string) throws IOException {
        this.write(string);
    }

    public void pI() {
        this.indentIn();
    }

    public void pO() {
        this.indentOut();
    }

    public void pO(Object object) throws IOException {
        this.pO();
        this.p(object.toString());
    }

    public void pO(String string) throws IOException {
        this.pO();
        this.p(string);
    }

    public void pOln(Object object) throws IOException {
        this.pO(object.toString());
        this.pln();
    }

    public void pOln(String string) throws IOException {
        this.pO(string);
        this.pln();
    }

    public void pOlnI(Object object) throws IOException {
        this.pO(object.toString());
        this.pln();
        this.pI();
    }

    public void pOlnI(String string) throws IOException {
        this.pO(string);
        this.pln();
        this.pI();
    }

    public void pln() throws IOException {
        this.newLine();
    }

    public void pln(Object object) throws IOException {
        this.p(object.toString());
        this.pln();
    }

    public void pln(String string) throws IOException {
        this.p(string);
        this.pln();
    }

    public void plnI(Object object) throws IOException {
        this.p(object.toString());
        this.pln();
        this.pI();
    }

    public void plnI(String string) throws IOException {
        this.p(string);
        this.pln();
        this.pI();
    }

    public void write(int n2) throws IOException {
        this.checkWrite();
        super.write(n2);
    }

    public void write(String string, int n2, int n3) throws IOException {
        if (n3 > 0) {
            this.checkWrite();
        }
        super.write(string, n2, n3);
    }

    public void write(char[] cArray, int n2, int n3) throws IOException {
        if (n3 > 0) {
            this.checkWrite();
        }
        super.write(cArray, n2, n3);
    }
}

