/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.rmic.iiop;

import sun.rmi.rmic.Constants;
import sun.rmi.rmic.iiop.BatchEnvironment;
import sun.rmi.rmic.iiop.ContextStack;
import sun.rmi.rmic.iiop.IDLNames;
import sun.rmi.rmic.iiop.InterfaceType;
import sun.rmi.rmic.iiop.Type;
import sun.tools.java.ClassDefinition;
import sun.tools.java.ClassNotFound;
import sun.tools.java.CompilerError;
import sun.tools.java.Environment;
import sun.tools.java.Identifier;

public class SpecialInterfaceType
extends InterfaceType {
    private SpecialInterfaceType(ContextStack contextStack, int n2, ClassDefinition classDefinition) {
        super(contextStack, n2 | 0x20000000 | 0x8000000 | 0x2000000, classDefinition);
        this.setNames(classDefinition.getName(), null, null);
    }

    public static SpecialInterfaceType forSpecial(ClassDefinition classDefinition, ContextStack contextStack) {
        if (contextStack.anyErrors()) {
            return null;
        }
        sun.tools.java.Type type = classDefinition.getType();
        Type type2 = Type.getType(type, contextStack);
        if (type2 != null) {
            if (!(type2 instanceof SpecialInterfaceType)) {
                return null;
            }
            return (SpecialInterfaceType)type2;
        }
        if (SpecialInterfaceType.isSpecial(type, classDefinition, contextStack)) {
            SpecialInterfaceType specialInterfaceType = new SpecialInterfaceType(contextStack, 0, classDefinition);
            Type.putType(type, (Type)specialInterfaceType, contextStack);
            contextStack.push(specialInterfaceType);
            if (specialInterfaceType.initialize(type, contextStack)) {
                contextStack.pop(true);
                return specialInterfaceType;
            }
            Type.removeType(type, contextStack);
            contextStack.pop(false);
            return null;
        }
        return null;
    }

    public String getTypeDescription() {
        return "Special interface";
    }

    private boolean initialize(sun.tools.java.Type type, ContextStack contextStack) {
        boolean bl2;
        int n2 = 0;
        Identifier identifier = null;
        String string = null;
        String[] stringArray = null;
        boolean bl3 = bl2 = contextStack.size() > 0 && contextStack.getContext().isConstant();
        if (type.isType(10)) {
            identifier = type.getClassName();
            if (identifier.equals(Constants.idRemote)) {
                n2 = 524288;
                string = "Remote";
                stringArray = sun.rmi.rmic.iiop.Constants.IDL_JAVA_RMI_MODULE;
            } else if (identifier == sun.tools.java.Constants.idJavaIoSerializable) {
                n2 = 1024;
                string = "Serializable";
                stringArray = sun.rmi.rmic.iiop.Constants.IDL_JAVA_IO_MODULE;
            } else if (identifier == sun.rmi.rmic.iiop.Constants.idJavaIoExternalizable) {
                n2 = 1024;
                string = "Externalizable";
                stringArray = sun.rmi.rmic.iiop.Constants.IDL_JAVA_IO_MODULE;
            } else if (identifier == sun.rmi.rmic.iiop.Constants.idIDLEntity) {
                n2 = 1024;
                string = "IDLEntity";
                stringArray = sun.rmi.rmic.iiop.Constants.IDL_ORG_OMG_CORBA_PORTABLE_MODULE;
            } else {
                n2 = 2048;
                if (identifier == sun.rmi.rmic.iiop.Constants.idCorbaObject) {
                    string = IDLNames.getTypeName(n2, bl2);
                    stringArray = null;
                } else {
                    try {
                        string = IDLNames.getClassOrInterfaceName(identifier, this.env);
                        stringArray = IDLNames.getModuleNames(identifier, this.isBoxed(), this.env);
                    }
                    catch (Exception exception) {
                        Type.failedConstraint(7, false, contextStack, identifier.toString(), exception.getMessage());
                        throw new CompilerError("");
                    }
                }
            }
        }
        if (n2 == 0) {
            return false;
        }
        this.setTypeCode(n2 | 0x20000000 | 0x8000000 | 0x2000000);
        if (string == null) {
            throw new CompilerError("Not a special type");
        }
        this.setNames(identifier, stringArray, string);
        return this.initialize(null, null, null, contextStack, false);
    }

    private static boolean isSpecial(sun.tools.java.Type type, ClassDefinition classDefinition, ContextStack contextStack) {
        block8: {
            if (!type.isType(10)) break block8;
            Identifier identifier = type.getClassName();
            if (identifier.equals(Constants.idRemote)) {
                return true;
            }
            if (identifier == sun.tools.java.Constants.idJavaIoSerializable) {
                return true;
            }
            if (identifier == sun.rmi.rmic.iiop.Constants.idJavaIoExternalizable) {
                return true;
            }
            if (identifier == sun.rmi.rmic.iiop.Constants.idCorbaObject) {
                return true;
            }
            if (identifier == sun.rmi.rmic.iiop.Constants.idIDLEntity) {
                return true;
            }
            BatchEnvironment batchEnvironment = contextStack.getEnv();
            try {
                if (batchEnvironment.defCorbaObject.implementedBy((Environment)batchEnvironment, classDefinition.getClassDeclaration())) {
                    return true;
                }
            }
            catch (ClassNotFound classNotFound) {
                Type.classNotFound(contextStack, classNotFound);
            }
        }
        return false;
    }
}

