/* local additions to Apache httpd
 *
 */

#include <stdio.h>
#include <string.h>
#include <hesiod.h>
#include <httpd.h>
#include "http_config.h"
#include "http_log.h"
#include "http_main.h"
/*
    { "ShortURLs", cmd_shorturls, NULL, NULL, FLAG, 
    "On or Off to enable or disable Athena AFS short URLS"},
    */
command_rec athena_cmds[] = {
    { NULL }
};

typedef struct {
    char *real;
    char *shorturl;
} athena_entry;

module athena_module;


/* lookup_locker -- translate a locker name into an AFS path
 *   locker --  name of the locker
 *   returns:   AFS path (or NULL on failure)
 */
static char* lookup_locker (char *locker, request_rec *r)
{
  char **cpp;

  cpp = hes_resolve(locker, "filsys");
  if (cpp) {
    char* hesi = *cpp;         /* we only look at the first locker entry */
    if (hesi && !strncmp(hesi,"AFS ",4)) {
      char *spc, *ret;

      hesi += 4;               /* skip "AFS " */
#ifdef SKIP_ATHENA_CELL
      if (!strncmp(hesi,"/afs/athena.mit.edu",19))
	hesi += 19;            /* skip "/afs/athena.mit.edu" */
#endif

      spc = strchr(hesi, 32);  /* strip the remaining fields */
      if (spc) *spc='\0';

      ret = (char*)malloc(strlen(hesi)+1);

      /* for now, we'll fail without indicating what happened if we get NULL */
      if (!ret) return NULL;

      strcpy(ret, hesi);
      return ret;
    }
  }
  return NULL;
}

/* hes_lookup -- translate a locker URL into a full AFS gateway path
 *   current --  current request path
 *   returns:    translated path
 */
char* hes_lookup (request_rec *r)
{
    char *lockername, *end;
    char *p;
    int twiddle = 0;

    if (strncmp (r->uri+1, "~", 1) == 0) {
      twiddle = 1;
      lockername = (char *)malloc(strlen(r->uri) - 2);
      strcpy (lockername, r->uri + 2 );
    }
    else {
      lockername = (char *)malloc(strlen(r->uri) - 1);
      strcpy (lockername, r->uri + 1);
    }

    end = strchr(lockername, '/');
    if (end) {
      *end = '\0';
      end++;
    }

    if (*lockername) {
	char* lpath = lookup_locker(lockername, r);

	if (lpath) {
	    int homelen = strlen(lpath);
	    char * d = (char*)malloc(homelen +
				     (end ? strlen(end) : 0) + 
				     (twiddle ? 5 : 0) +
				      3);

	    if (!d) {free(lpath); return NULL;}

	    strcpy(d, lpath);
	    if (twiddle) {
	      strcat (d, "/www");
	      if (!end) {
		strcat (d, "/");
	      }
	    }
	    if (end) {
	        strcat (d, "/");
		strcat(d, end);
	    }
	    free(lpath);
	    return d;
	}
    }
    return NULL;
}

int athena_trans(request_rec *r)
{
    void *sconf = r->server->module_config;
    char *ret;
    int status;

    if (strncmp (r->uri, "/afs", 4) == 0) {
      return DECLINED;
    }

    if ((ret = hes_lookup (r)) != NULL) {
	if (*(ret + strlen(ret)) == '/') {
	  r->uri = ret;
	}
	else {
	  r->filename = ret;
	}
        return OK;
    }
    
    return DECLINED;
}



module athena_module = {
   STANDARD_MODULE_STUFF,
   NULL,			/* initializer */
   NULL,			/* dir config creater */
   NULL,			/* dir merger --- default is to override */
   NULL,			/* server config */
   NULL,			/* merge server configs */
   NULL,			/* command table */
   NULL,			/* handlers */
   athena_trans,		/* filename translation */
   NULL,			/* check_user_id */
   NULL,			/* check auth */
   NULL,			/* check access */
   NULL,			/* type_checker */
   NULL,			/* fixups */
   NULL,			/* logger */
   NULL				/* header parser */
};

