/**********
 * Copyright (c) 2007 Alejandro R Sedeno.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 **********/

#include "includes.h"
#include "pealstub.h"

/*
void dbg_beep(int, int);
void dbg_beep(int hz, int ms)
{
     SndCommandType snd;
     UInt16 volume = PrefGetPreference(prefGameSoundVolume);
     snd.cmd = sndCmdFreqDurationAmp;
     snd.reserved = 0;
     snd.param1 = hz; // frequency in Hz
     snd.param2 = ms; // duration in ms
     snd.param3 = volume; // volume [0..sndMaxAmp]
     SndDoCmd(NULL, &snd, false);
}
*/
static int deviceTreo6x0 = 0;

uint32_t CheckDeviceTreo_stub(uint32_t *);
uint32_t CheckDeviceTreo_stub(uint32_t *param) {
  uint32_t companyID = 0;
  uint32_t deviceID = 0;
  FtrGet(sysFtrCreator, sysFtrNumOEMCompanyID, &companyID);
  FtrGet(sysFtrCreator, sysFtrNumOEMDeviceID, &deviceID);
  
  if (((companyID == 'hspr') &&
       (deviceID == 'H101' || deviceID == 'H102')) ||
      (companyID == 'Palm' &&
       (deviceID == 'D052' || deviceID == 'D053'))) {
    deviceTreo6x0 = 1;
  }
  return deviceTreo6x0;
}

/* Alternate keymap for alt key */

static unsigned char altsym_symbol_map[32] = {
    /* SP */ ' ',     /* !  */ '|',     /* "  */ '~',     /* #  */ '{',
    /* $  */ '%',     /* %  */ '%',     /* &  */ '&',     /* '  */ '`',
    /* (  */ '[',     /* )  */ ']',     /* *  */ '^',     /* +  */ '=',
    /* ,  */ '<',     /* -  */ '_',     /* .  */ '>',     /* /  */ '\\',
    /* 0  */ ')',     /* 1  */ '!',     /* 2  */ '@',     /* 3  */ '#',
    /* 4  */ '$',     /* 5  */ '%',     /* 6  */ '^',     /* 7  */ '&',
    /* 8  */ '*',     /* 9  */ '(',     /* :  */ ';',     /* ;  */ ':',
    /* <  */ ',',     /* =  */ '+',     /* >  */ '.',     /* ?  */ '}'
};

static unsigned char altsym_treo_map[26] = {
    /* A */ '&',   /* B */ '{',   /* C */ '*',   /* D */ '$',   /* E */ '!',
    /* F */ '%',   /* G */ '^',   /* H */ '%',   /* I */ '&',   /* J */ '|',
    /* K */ ';',   /* L */ '`',   /* M */ '<',   /* N */ '}',   /* O */ '~',
    /* P */ '%',   /* Q */ '\\',  /* R */ '@',   /* S */ '_',   /* T */ '#',
    /* U */ ']',   /* V */ '(',   /* W */ '=',   /* X */ '&',   /* Y */ '[',
    /* Z */ '^'
};

static unsigned char altsym_tungsten_map[26] = {
    /* A */ ';',   /* B */ '|',   /* C */ ']',   /* D */ '=',   /* E */ '#',
    /* F */ '_',   /* G */ '^',   /* H */ '-',   /* I */ '*',   /* J */ '~',
    /* K */ '`',   /* L */ '&',   /* M */ '}',   /* N */ '<',   /* O */ '(',
    /* P */ ')',   /* Q */ '!',   /* R */ '$',   /* S */ '\\',  /* T */ '%',
    /* U */ '&',   /* V */ '{',   /* W */ '@',   /* X */ '[',   /* Y */ '^',
    /* Z */ '%'

};

uint32_t altsym_character_stub(unsigned char *);
uint32_t altsym_character_stub(unsigned char *c) {
  if (*c == '@') return '&';
  if (*c == '_') return '-';
  if (*c >= 0x20 && *c < 0x40) return (uint32_t) altsym_symbol_map[*c - 0x20];
  if (deviceTreo6x0) {
    if (*c >= 'A' && *c <= 'Z') return (uint32_t) altsym_treo_map[*c - 'A'];
    if (*c >= 'a' && *c <= 'z') return (uint32_t) altsym_treo_map[*c - 'a'];
  } else {
    // for now, use tungsten layout on all but treo
    // note there is currently no way to get altPressed on the tungsten
    if (*c >= 'A' && *c <= 'Z') return (uint32_t) altsym_tungsten_map[*c - 'A'];
    if (*c >= 'a' && *c <= 'z') return (uint32_t) altsym_tungsten_map[*c - 'a'];
  }
  return (uint32_t) *c;
}

uint32_t control_character_stub(unsigned char *);
uint32_t control_character_stub(unsigned char *c) {
  if (*c == ' '  ||  *c == '@') return '\0';        // C-space, C-@
  if (*c >= 'a'  &&  *c <= 'z') return *c - 'a' + 1; // C-a .. C-z
  if (*c >= 'A'  &&  *c <= 'Z') return *c - 'A' + 1; // C-A .. C-Z
  if (*c >= '['  &&  *c <= '_') return *c - 'A' + 1; // C-[ .. C-_
  if (*c >= '{'  &&  *c <= '}') return *c - 'a' + 1; // C-{ .. C-} (no C-~)
  return c;
}
