/**********
 * Copyright (c) 2005 Greg Parker.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY GREG PARKER ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 **********/

#include "sshzlib.h"
#include "pealstub.h"
#include "swap.h"

uint32_t zlib_compress_init_stub(uint32_t *param);
uint32_t zlib_compress_cleanup_stub(uint32_t *param);
uint32_t zlib_decompress_init_stub(uint32_t *param);
uint32_t zlib_decompress_cleanup_stub(uint32_t *param);
uint32_t zlib_compress_block_stub(uint32_t *param);
uint32_t zlib_decompress_block_stub(uint32_t *param);


uint32_t zlib_compress_init_stub(uint32_t *param)
{
    return (uint32_t) zlib_compress_init();
}


uint32_t zlib_compress_cleanup_stub(uint32_t *param)
{
    void *ctx = (void *)read32(&param[0]);
    zlib_compress_cleanup(ctx);
    return 0;
}


uint32_t zlib_decompress_init_stub(uint32_t *param)
{
    return (uint32_t) zlib_decompress_init();
}


uint32_t zlib_decompress_cleanup_stub(uint32_t *param)
{
    void *ctx = (void *)read32(&param[0]);
    zlib_decompress_cleanup(ctx);
    return 0;
}


uint32_t zlib_compress_block_stub(uint32_t *param)
{
    void *ctx = (void *)read32(&param[0]);
    unsigned char *block = (unsigned char *)read32(&param[1]);
    size_t len = (size_t)read32(&param[2]);
    unsigned char **outblockP = (unsigned char **)read32(&param[3]);
    size_t *outlenP= (size_t *)read32(&param[4]);

    unsigned char *outblock;
    size_t outlen;
    int result;

    if (outblockP) outblock = (unsigned char *)read32(outblockP);
    if (outlenP) outlen = (size_t)read32(outlenP);

    result = zlib_compress_block(ctx, block, len, &outblock, &outlen);

    if (outblockP) write32(outblockP, (uint32_t)outblock);
    if (outlenP) write32(outlenP, outlen);

    return (uint32_t) result;
}


uint32_t zlib_decompress_block_stub(uint32_t *param)
{
    void *ctx = (void *)read32(&param[0]);
    unsigned char *block = (unsigned char *)read32(&param[1]);
    size_t len = (size_t)read32(&param[2]);
    unsigned char **outblockP = (unsigned char **)read32(&param[3]);
    size_t *outlenP = (size_t *)read32(&param[4]);

    unsigned char *outblock;
    size_t outlen;
    int result;

    if (outblockP) outblock = (unsigned char *)read32(outblockP);
    if (outlenP) outlen = (size_t)read32(outlenP);

    result = zlib_decompress_block(ctx, block, len, &outblock, &outlen);

    if (outblockP) write32(outblockP, (uint32_t)outblock);
    if (outlenP) write32(outlenP, outlen);

    return (uint32_t) result;
}


