/**********
 * Copyright (c) 2004 Greg Parker.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY GREG PARKER ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 **********/

#include "includes.h"
#include "rand.h"
#include "armstubs.h"

void RAND_init(void) {
    static void *sym = NULL;
    if (!sym) sym = PealLookupSymbol(arm_module, __FUNCTION__ "_stub");
    if (!sym) fatal("no ARM symbol %s", __FUNCTION__ "_stub");

    PealCall(arm_module, sym, 0);
}


void RAND_stop(void) {
    static void *sym = NULL;
    if (!sym) sym = PealLookupSymbol(arm_module, __FUNCTION__ "_stub");
    if (!sym) fatal("no ARM symbol %s", __FUNCTION__ "_stub");

    PealCall(arm_module, sym, 0);
}


int32_t RAND_bytes(char *buf, uint32_t len) {
    uint32_t param[2];
    static void *sym = NULL;
    if (!sym) sym = PealLookupSymbol(arm_module, __FUNCTION__ "_stub");
    if (!sym) fatal("no ARM symbol %s", __FUNCTION__ "_stub");

    param[0] = (uint32_t)buf;
    param[1] = (uint32_t)len;
    return (int32_t) PealCall(arm_module, sym, param);
}


void RAND_add_event_entropy(EventType *e) {
    uint32_t param[1];
    static void *sym = NULL;
    if (!sym) sym = PealLookupSymbol(arm_module, __FUNCTION__ "_stub");
    if (!sym) fatal("no ARM symbol %s", __FUNCTION__ "_stub");

    param[0] = (uint32_t)e;
    PealCall(arm_module, sym, param);
}


void RAND_add_net_entropy(void) {
    static void *sym = NULL;
    if (!sym) sym = PealLookupSymbol(arm_module, __FUNCTION__ "_stub");
    if (!sym) fatal("no ARM symbol %s", __FUNCTION__ "_stub");

    PealCall(arm_module, sym, 0);
}


