/**********
 * Copyright (c) 2004 Greg Parker.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY GREG PARKER ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 **********/

#include "includes.h"
#include "recordlist.h"
#include "rsrc/rsrc.h"
#include "formutils.h"

#include "memolist.h"


#define MemoDBName "MemoDB"
static DmOpenRef MemoDB = 0;
static RecordList *MemoList = NULL;

static void DrawMemo(MemPtr recordP, UInt16 index, RectanglePtr bounds) DATA_SEGMENT;

Boolean MemoListInit(void)
{
    MemoDB = DmOpenDatabaseByTypeCreator('DATA', 'memo', dmModeReadWrite);
    if (!MemoDB) {
        return false;
    }

    MemoList = RecordListNew(MemoDB, MemoFormID, MemoFormTableID, 
                             MemoFormScrollbarID, DrawMemo);
    if (!MemoList) {
        DmCloseDatabase(MemoDB);
        return false;
    }
    return true;
}

void MemoListFree(void)
{
    if (MemoList) RecordListFree(MemoList);
    if (MemoDB) DmCloseDatabase(MemoDB);
    MemoList = NULL;
    MemoDB = 0;
}

void MemoListUpdate(void) {
    if (MemoList) RecordListUpdate(MemoList);
}

UInt16 MemoListSelectedIndex(void) {
    if (MemoList) return RecordListSelectedIndex(MemoList);
    else return noRecord;
}

void MemoListSetSelectedIndex(UInt16 index) {
    if (MemoList) RecordListSetSelectedIndex(MemoList, index);
}

void MemoListClearSelection(void) {
    if (MemoList) RecordListClearSelection(MemoList);
}

Boolean MemoListHandleEvent(EventPtr event) {
    if (MemoList) return RecordListHandleEvent(MemoList, event);
    else return false;
}

MemHandle MemoListQuerySelectedRecord(void)
{
    if (MemoList) {
        UInt16 index = RecordListSelectedIndex(MemoList);
        if (index != noRecord) {
            // hack to cope with hidden records, which RecordList cannot
            UInt16 realIndex = 0;
            Err err = DmSeekRecordInCategory(MemoDB, &realIndex, index, 
                                             dmSeekForward, dmAllCategories);
            if (!err) {
                return RecordListQueryIndexedRecord(MemoList, realIndex);
            }
        }
    } 

    return NULL;
}

static void DrawMemo(MemPtr recordP, UInt16 index, RectanglePtr bounds)
{
    int x = bounds->topLeft.x + 1;
    int y = bounds->topLeft.y;
    
    char *start = recordP;
    char *endR = strchr(start, '\r');
    char *endN = strchr(start, '\n');
    char *end = start + MemPtrSize(start);
    uint16_t length = end - start;

    if (endR) length = MIN(length, endR - start);
    if (endN) length = MIN(length, endN - start);

    WinDrawTruncChars(start, length, x, y, bounds->topLeft.x + bounds->extent.x - x - 1);
}
