/**********
 * Copyright (c) 2003-2005 Greg Parker.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY GREG PARKER ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 **********/

#include "includes.h"
#include "formutils.h"
#include "data/connectionlist.h"
#include "rsrc/rsrc.h"
#include "forms/resize.h"

#include "detailsform.h"


static Boolean LoadDetailsForm(void) FORMS_SEGMENT;
static Boolean SaveDetailsForm(void) FORMS_SEGMENT;


static Boolean LoadDetailsForm(void)
{
    MemHandle recordH;
    Boolean ok = true;
    char *hostname;
    char *username;
    char *portname;

    recordH=ConnectionListReadSelectedRecord(&hostname, &portname, &username);
    if (!recordH) return false;

    if (ok) ok = PrvSetFieldToValueByID(DetailsFormHostFieldID, hostname);
    if (ok) ok = PrvSetFieldToValueByID(DetailsFormPortFieldID, portname);
    if (ok) ok = PrvSetFieldToValueByID(DetailsFormUsernameFieldID, username);

    MemHandleUnlock(recordH);

    return ok;    
}


static Boolean SaveDetailsForm(void)
{
    FieldPtr hostFld = PrvGetObjectByID(DetailsFormHostFieldID);
    FieldPtr portFld = PrvGetObjectByID(DetailsFormPortFieldID);
    FieldPtr userFld = PrvGetObjectByID(DetailsFormUsernameFieldID);

    if (FldDirty(hostFld)  ||  FldDirty(portFld)  ||  FldDirty(userFld)) {
        return ConnectionListWriteSelectedRecord(hostFld, portFld, userFld);
    } else {
        return true;
    }
}


Boolean DetailsFormHandleEvent(EventPtr e)
{
    FormPtr frmP = FrmGetActiveForm();

    if (ResizeHandleEvent(e)) return true;

    switch (e->eType) {
    case frmOpenEvent: {
        LoadDetailsForm();
        FrmDrawForm(frmP);
        return true;
    }

    case ctlSelectEvent:
        switch (e->data.ctlSelect.controlID) {
        case DetailsFormOKButtonID:
            // save connection info, return to main form
            // Don't validate - let the user enter anything
            if (!SaveDetailsForm()) {
                // failed to save connection info
                // fixme
            }
            FrmReturnToForm(0);
            break;

        case DetailsFormCancelButtonID:
            // return to main form
            FrmReturnToForm(0);
            break;

        case DetailsFormDeleteButtonID:
            if (0 == FrmAlert(DeleteConnectionAlertID)) {
                ConnectionListDeleteSelectedRecord();
                FrmReturnToForm(0);
            }
            break;

        default:
            break;
        }

        return true;

    case frmCloseEvent:
        return false;

    default: 
        return false;
    }
}

