/**********
 * Copyright (c) 2003-2004 Greg Parker.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY GREG PARKER ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 **********/

// ctype.h replacement

#ifndef CTYPE_H
#define CTYPE_H

static inline int isdigit(unsigned char c);
static inline int isxdigit(unsigned char c);
static inline int iscntrl(unsigned char c);
static inline int isprint(unsigned char c);
static inline int isspace(unsigned char c);
static inline int isupper(unsigned char c);

static inline unsigned char tolower(unsigned char c);
static inline unsigned char toupper(unsigned char c);


static inline int isdigit(unsigned char c) {
    return (c >= '0'  &&  c <= '9');
}


static inline int isxdigit(unsigned char c) {
    return ((c >= '0'  &&  c <= '9')  ||  
            (c >= 'a'  &&  c <= 'f')  ||  
            (c >= 'A'  &&  c <= 'F'));
}


static inline int iscntrl(unsigned char c) {
    return (c <= 037  ||  c == 0177);
}


static inline int isprint(unsigned char c) {
    return (c >= 040  &&  c <= 0176);
}


static inline int isspace(unsigned char c) {
    return (c == '\t'  ||  c == '\n'  ||  c == '\v'  ||  
            c == '\f'  ||  c == '\r'  ||  c == ' ');
}


static inline int isupper(unsigned char c) {
    return (c >= 'A'  &&  c <= 'Z');
}


static inline unsigned char tolower(unsigned char c) {
    if (c >= 'A'  &&  c <= 'Z') {
        return c - 'A' + 'a';
    } else {
        return c;
    }
}

static inline unsigned char toupper(unsigned char c) {
    if (c >= 'a'  &&  c <= 'a') {
        return c - 'a' + 'A';
    } else {
        return c;
    }
}


#endif
