/**********
 * Copyright (c) 2003-2004 Greg Parker.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY GREG PARKER ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 **********/

#include "includes.h"
#include "vt100.h"
#include "armstubs.h"
#include "peal.h"


// bounds is STANDARD-RESOLUTION
struct display *vt100_new(struct ssh_session_t *ss, RectangleType bounds) 
{
    uint32_t param[5];
    static void *sym = NULL;
    if (!sym) sym = PealLookupSymbol(arm_module, __FUNCTION__ "_stub");
    if (!sym) fatal("no ARM symbol %s", __FUNCTION__ "_stub");
    vt100_log(__PRETTY_FUNCTION__);

    param[0] = (uint32_t)ss;
    param[1] = (uint32_t)&bounds;
    return (struct display *) PealCall(arm_module, sym, param);
}


void vt100_free(struct display *disp) 
{
    uint32_t param[1];
    static void *sym = NULL;
    if (!sym) sym = PealLookupSymbol(arm_module, __FUNCTION__ "_stub");
    if (!sym) fatal("no ARM symbol %s", __FUNCTION__ "_stub");
    vt100_log(__PRETTY_FUNCTION__);

    param[0] = (uint32_t)disp;
    PealCall(arm_module, sym, param);
}


void vt100_write(struct display *disp, const char *bytes, size_t len) 
{
    uint32_t param[3];
    static void *sym = NULL;
    if (!sym) sym = PealLookupSymbol(arm_module, __FUNCTION__ "_stub");
    if (!sym) fatal("no ARM symbol %s", __FUNCTION__ "_stub");
    vt100_log(__PRETTY_FUNCTION__);

    param[0] = (uint32_t)disp;
    param[1] = (uint32_t)bytes;
    param[2] = (uint32_t)len;
    PealCall(arm_module, sym, param);
}


void vt100_update(struct display *disp) 
{
    uint32_t param[1];
    static void *sym = NULL;
    if (!sym) sym = PealLookupSymbol(arm_module, __FUNCTION__ "_stub");
    if (!sym) fatal("no ARM symbol %s", __FUNCTION__ "_stub");
    vt100_log(__PRETTY_FUNCTION__);

    param[0] = (uint32_t)disp;
    PealCall(arm_module, sym, param);
}


void vt100_task(struct display *disp) 
{
    uint32_t param[1];
    static void *sym = NULL;
    if (!sym) sym = PealLookupSymbol(arm_module, __FUNCTION__ "_stub");
    if (!sym) fatal("no ARM symbol %s", __FUNCTION__ "_stub");
    vt100_log(__PRETTY_FUNCTION__);

    param[0] = (uint32_t)disp;
    PealCall(arm_module, sym, param);
}


void vt100_scroll(struct display *disp, int lines) 
{
    uint32_t param[2];
    static void *sym = NULL;
    if (!sym) sym = PealLookupSymbol(arm_module, __FUNCTION__ "_stub");
    if (!sym) fatal("no ARM symbol %s", __FUNCTION__ "_stub");
    vt100_log(__PRETTY_FUNCTION__);

    param[0] = (uint32_t)disp;
    param[1] = (uint32_t)lines;
    PealCall(arm_module, sym, param);
}


void vt100_activate(struct display *disp) 
{
    uint32_t param[1];
    static void *sym = NULL;
    if (!sym) sym = PealLookupSymbol(arm_module, __FUNCTION__ "_stub");
    if (!sym) fatal("no ARM symbol %s", __FUNCTION__ "_stub");
    vt100_log(__PRETTY_FUNCTION__);

    param[0] = (uint32_t)disp;
    PealCall(arm_module, sym, param);
}


void vt100_deactivate(struct display *disp) 
{
    uint32_t param[1];
    static void *sym = NULL;
    if (!sym) sym = PealLookupSymbol(arm_module, __FUNCTION__ "_stub");
    if (!sym) fatal("no ARM symbol %s", __FUNCTION__ "_stub");
    vt100_log(__PRETTY_FUNCTION__);

    param[0] = (uint32_t)disp;
    PealCall(arm_module, sym, param);
}


// in: bounds (STANDARD-RESOLUTION)
// out: charsWide and charsHigh
void vt100_set_bounds(struct display *disp, RectangleType bounds) 
{
    uint32_t param[5];
    static void *sym = NULL;
    if (!sym) sym = PealLookupSymbol(arm_module, __FUNCTION__ "_stub");
    if (!sym) fatal("no ARM symbol %s", __FUNCTION__ "_stub");
    vt100_log(__PRETTY_FUNCTION__);

    param[0] = (uint32_t)disp;
    param[1] = (uint32_t)&bounds;
    PealCall(arm_module, sym, param);
}


// x and y are STANDARD-RESOLUTION
// clickCount is 1 or more for mouse down, 0 for mouse up
void vt100_click(struct display *disp, int x, int y, int clickCount) 
{
    uint32_t param[4];
    static void *sym = NULL;
    if (!sym) sym = PealLookupSymbol(arm_module, __FUNCTION__ "_stub");
    if (!sym) fatal("no ARM symbol %s", __FUNCTION__ "_stub");
    vt100_log(__PRETTY_FUNCTION__);

    param[0] = (uint32_t)disp;
    param[1] = (uint32_t)x;
    param[2] = (uint32_t)y;
    param[3] = (uint32_t)clickCount;
    PealCall(arm_module, sym, param);
}


void vt100_deselect(struct display *disp) 
{
    uint32_t param[1];
    static void *sym = NULL;
    if (!sym) sym = PealLookupSymbol(arm_module, __FUNCTION__ "_stub");
    if (!sym) fatal("no ARM symbol %s", __FUNCTION__ "_stub");
    vt100_log(__PRETTY_FUNCTION__);

    param[0] = (uint32_t)disp;
    PealCall(arm_module, sym, param);
}


void vt100_copy(struct display *disp) 
{
    uint32_t param[1];
    static void *sym = NULL;
    if (!sym) sym = PealLookupSymbol(arm_module, __FUNCTION__ "_stub");
    if (!sym) fatal("no ARM symbol %s", __FUNCTION__ "_stub");
    vt100_log(__PRETTY_FUNCTION__);

    param[0] = (uint32_t)disp;
    PealCall(arm_module, sym, param);
}


void vt100_paste(struct display *disp) 
{
    uint32_t param[1];
    static void *sym = NULL;
    if (!sym) sym = PealLookupSymbol(arm_module, __FUNCTION__ "_stub");
    if (!sym) fatal("no ARM symbol %s", __FUNCTION__ "_stub");
    vt100_log(__PRETTY_FUNCTION__);

    param[0] = (uint32_t)disp;
    PealCall(arm_module, sym, param);
}


int vt100_selection_exists(struct display *disp) 
{
    uint32_t param[1];
    static void *sym = NULL;
    if (!sym) sym = PealLookupSymbol(arm_module, __FUNCTION__ "_stub");
    if (!sym) fatal("no ARM symbol %s", __FUNCTION__ "_stub");
    vt100_log(__PRETTY_FUNCTION__);

    param[0] = (uint32_t)disp;
    return (int) PealCall(arm_module, sym, param);
}


// bounds returned is NATIVE-RESOLUTION
void vt100_size(struct display *disp, int *charsWide, int *charsHigh, RectangleType *bounds) 
{
    uint32_t param[4];
    static void *sym = NULL;
    if (!sym) sym = PealLookupSymbol(arm_module, __FUNCTION__ "_stub");
    if (!sym) fatal("no ARM symbol %s", __FUNCTION__ "_stub");
    vt100_log(__PRETTY_FUNCTION__);

    param[0] = (uint32_t)disp;
    param[1] = (uint32_t)charsWide;
    param[2] = (uint32_t)charsHigh;
    param[3] = (uint32_t)bounds;
    PealCall(arm_module, sym, param);
}


void vt100_reread_prefs(struct display *disp) 
{
    uint32_t param[1];
    static void *sym = NULL;
    if (!sym) sym = PealLookupSymbol(arm_module, __FUNCTION__ "_stub");
    if (!sym) fatal("no ARM symbol %s", __FUNCTION__ "_stub");
    vt100_log(__PRETTY_FUNCTION__);

    param[0] = (uint32_t)disp;
    PealCall(arm_module, sym, param);
}


void vt100_seen_key(struct display *disp) 
{
    uint32_t param[1];
    static void *sym = NULL;
    if (!sym) sym = PealLookupSymbol(arm_module, __FUNCTION__ "_stub");
    if (!sym) fatal("no ARM symbol %s", __FUNCTION__ "_stub");
    vt100_log(__PRETTY_FUNCTION__);

    param[0] = (uint32_t)disp;
    PealCall(arm_module, sym, param);
}


int vt100_app_cursor_keys(struct display *disp) 
{
    uint32_t param[1];
    static void *sym = NULL;
    if (!sym) sym = PealLookupSymbol(arm_module, __FUNCTION__ "_stub");
    if (!sym) fatal("no ARM symbol %s", __FUNCTION__ "_stub");
    vt100_log(__PRETTY_FUNCTION__);

    param[0] = (uint32_t)disp;
    return (int) PealCall(arm_module, sym, param);
}


FontID font_for_screen(int fontPref)
{
    uint32_t param[1];
    static void *sym = NULL;
    if (!sym) sym = PealLookupSymbol(arm_module, __FUNCTION__ "_stub");
    if (!sym) fatal("no ARM symbol %s", __FUNCTION__ "_stub");
    vt100_log(__PRETTY_FUNCTION__);

    param[0] = (uint32_t)fontPref;
    return (FontID) PealCall(arm_module, sym, param);
}


void set_palm_color(int fg_color, int bg_color)
{
    uint32_t param[2];
    static void *sym = NULL;
    if (!sym) sym = PealLookupSymbol(arm_module, __FUNCTION__ "_stub");
    if (!sym) fatal("no ARM symbol %s", __FUNCTION__ "_stub");
    vt100_log(__PRETTY_FUNCTION__);

    param[0] = (uint32_t)fg_color;
    param[1] = (uint32_t)bg_color;
    PealCall(arm_module, sym, param);
}
