/**********
 * Copyright (c) 2003-2004 Greg Parker.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY GREG PARKER ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 **********/

#include "aes_includes.h"
#include "aes_tables.h"

// fixme copied from cryptorsrc.h
#define AES_Te0_id 9010
#define AES_Te1_id 9011
#define AES_Te2_id 9012
#define AES_Te3_id 9013
#define AES_Te4_id 9014
#define AES_Td0_id 9015
#define AES_Td1_id 9016
#define AES_Td2_id 9017
#define AES_Td3_id 9018
#define AES_Td4_id 9019

// resource handles
static MemHandle Te0_h = NULL;
static MemHandle Te1_h = NULL;
static MemHandle Te2_h = NULL;
static MemHandle Te3_h = NULL;
static MemHandle Te4_h = NULL;
static MemHandle Td0_h = NULL;
static MemHandle Td1_h = NULL;
static MemHandle Td2_h = NULL;
static MemHandle Td3_h = NULL;
static MemHandle Td4_h = NULL;

// from aes_core.c
extern const u32 *Te0;
extern const u32 *Te1;
extern const u32 *Te2;
extern const u32 *Te3;
extern const u32 *Te4;
extern const u32 *Td0;
extern const u32 *Td1;
extern const u32 *Td2;
extern const u32 *Td3;
extern const u32 *Td4;

void aes_init_tables(void)
{
    // fixme error handling

    // grab data from resources
    Te0_h = DmGetResource('adwd', AES_Te0_id);
    Te1_h = DmGetResource('adwd', AES_Te1_id);
    Te2_h = DmGetResource('adwd', AES_Te2_id);
    Te3_h = DmGetResource('adwd', AES_Te3_id);
    Te4_h = DmGetResource('adwd', AES_Te4_id);
    Td0_h = DmGetResource('adwd', AES_Td0_id);
    Td1_h = DmGetResource('adwd', AES_Td1_id);
    Td2_h = DmGetResource('adwd', AES_Td2_id);
    Td3_h = DmGetResource('adwd', AES_Td3_id);
    Td4_h = DmGetResource('adwd', AES_Td4_id);

    // adwd resource is prefixed with 4-byte word count
    // AES tables should be 256 words long, plus the count word

    // verify handle sizes
    assert(MemHandleSize(Te0_h) == 4*(1+256));
    assert(MemHandleSize(Te1_h) == 4*(1+256));
    assert(MemHandleSize(Te2_h) == 4*(1+256));
    assert(MemHandleSize(Te3_h) == 4*(1+256));
    assert(MemHandleSize(Te4_h) == 4*(1+256));
    assert(MemHandleSize(Td0_h) == 4*(1+256));
    assert(MemHandleSize(Td1_h) == 4*(1+256));
    assert(MemHandleSize(Td2_h) == 4*(1+256));
    assert(MemHandleSize(Td3_h) == 4*(1+256));
    assert(MemHandleSize(Td4_h) == 4*(1+256));
}


void aes_lock_tables(void)
{
    if (!Te0_h) aes_init_tables();

    // lock and skip 4-byte word count
    Te0 = 1 + (const u32 *)MemHandleLock(Te0_h);
    Te1 = 1 + (const u32 *)MemHandleLock(Te1_h);
    Te2 = 1 + (const u32 *)MemHandleLock(Te2_h);
    Te3 = 1 + (const u32 *)MemHandleLock(Te3_h);
    Te4 = 1 + (const u32 *)MemHandleLock(Te4_h);
    Td0 = 1 + (const u32 *)MemHandleLock(Td0_h);
    Td1 = 1 + (const u32 *)MemHandleLock(Td1_h);
    Td2 = 1 + (const u32 *)MemHandleLock(Td2_h);
    Td3 = 1 + (const u32 *)MemHandleLock(Td3_h);
    Td4 = 1 + (const u32 *)MemHandleLock(Td4_h);
}


void aes_unlock_tables(void)
{
    MemHandleUnlock(Te0_h); Te0 = NULL;
    MemHandleUnlock(Te1_h); Te1 = NULL;
    MemHandleUnlock(Te2_h); Te2 = NULL;
    MemHandleUnlock(Te3_h); Te3 = NULL;
    MemHandleUnlock(Te4_h); Te4 = NULL;
    MemHandleUnlock(Td0_h); Td0 = NULL;
    MemHandleUnlock(Td1_h); Td1 = NULL;
    MemHandleUnlock(Td2_h); Td2 = NULL;
    MemHandleUnlock(Td3_h); Td3 = NULL;
    MemHandleUnlock(Td4_h); Td4 = NULL;
}
