#include "includes.h"
#include "swap.h"
#include "rand.h"

uint32_t RAND_init_stub(void);
uint32_t RAND_stop_stub(void);
uint32_t RAND_bytes_stub(uint32_t *param);
uint32_t RAND_add_event_entropy_stub(uint32_t *param);
uint32_t RAND_add_net_entropy_stub(void);


uint32_t RAND_init_stub(void)
{
    RAND_init();
    return 0;
}


uint32_t RAND_stop_stub(void)
{
    RAND_stop();
    return 0;
}


uint32_t RAND_bytes_stub(uint32_t *param)
{
    char *buf = (char *)read32(&param[0]);
    uint32_t len = (uint32_t)read32(&param[1]);
    return (int32_t) RAND_bytes(buf, len);
}


uint32_t RAND_add_event_entropy_stub(uint32_t *param)
{
    EventType *e = (EventType *)read32(&param[0]);

    // swap eType, but don't bother with the rest
    // because we're only using it for entropy anyway
    swap16P(&e->eType);
    RAND_add_event_entropy(e);
    swap16P(&e->eType);
    return 0;
}


uint32_t RAND_add_net_entropy_stub(void)
{
    RAND_add_net_entropy();
    return 0;
}
