/**********
 * Copyright (c) 2004 Greg Parker.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY GREG PARKER ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 **********/

#include "includes.h"
#include "prefs.h"
#include "pace.h"

// There is one global default prefs list. 
// There is also a set of override values for each connection, mostly 
// for terminal settings.

// Each preference is a RESOURCE
// res type: 'dflt' or some ID for a connection override
// res id: which pref

/* 
   interface: 
   echo password (NO)
   keyboard pane(s)
   
   terminal:
   TERM type ("xterm")
   scrollback line count (500?)
   scroll down on input (NO)
   scroll down on keypress (YES)
   
   ssh:
   compression (NO) (fixme implement)
   ciphers ("aes128-cbc,3des-cbc")
   authmethod (fixme implement)
   
   putty terminal:
   wrap_mode (YES==autowrap)
   dec_om "DEC Origin Mode" (YES)
   lfhascr "Implicit CR in every LF" (NO)
   bce "Background Color Erase" (?)
   blink_text "Blink" (NO)
   answerback "Answerback to ^E" ("pssh")
   localecho (NO)
   localedit (NO)
   printing (NO)

   putty keyboard:
   bksp_is_delete "Backspace is DEL" (YES==^? rather than ^H)
   rxvt_homeend "rxvt Home and End" (NO)
   funky_type "Function Keys" (DIGITAL, Linux, xterm, VT400, VT100+, SCO)
   app_cursor "Application Cursor Keys" (NO?)
   app_keypad "Application Keypad" (NO?)
   nethack "NetHack Keypad" (NO)
   compose (NO) (use real compose key on keyboard?)
   ctrlalt (NO)
   
   lots more putty...
   
*/


#define noRecord ((UInt16)0xffff)


uintptr_t PrefsInit_68K = 0;
uintptr_t PrefsGetInt_68K = 0;
uintptr_t PrefsGetString_68K = 0;
uintptr_t PrefsPutInt_68K = 0;
uintptr_t PrefsPutString_68K = 0;

// static DmOpenRef PrefsDB = 0;
// fixme implement overrides

// extern DmOpenRef OpenDB(UInt32 type, char *name, Boolean resDB, Boolean create);

int PrefsInit(void)
{
    PACE_PARAMS = {
        0
    };

    return (int) PACE_EXEC_FN(PrefsInit_68K, 0);
}


uint32_t PrefsGetInt(uint32_t which, uint32_t defaultValue)
{
    PACE_PARAMS = {
        PACE_PARAMS_ADD32(which)
        PACE_PARAMS_ADD32(defaultValue)
    };

    return (uint32_t) PACE_EXEC_FN(PrefsGetInt_68K, 0);
}


void PrefsPutInt(uint32_t which, uint32_t value)
{
    PACE_PARAMS = {
        PACE_PARAMS_ADD32(which)
        PACE_PARAMS_ADD32(value)
    };

    PACE_EXEC_FN(PrefsPutInt_68K, 0);
}


char *PrefsGetString(uint32_t which, char *defaultValue)
{
    PACE_PARAMS = {
        PACE_PARAMS_ADD32(which)
        PACE_PARAMS_ADD32(defaultValue)
    };

    return (char *) PACE_EXEC_FN(PrefsGetString_68K, kPceNativeWantA0);
}


void PrefsPutString(uint32_t which, char *value)
{
    PACE_PARAMS = {
        PACE_PARAMS_ADD32(which)
        PACE_PARAMS_ADD32(value)
    };

    PACE_EXEC_FN(PrefsPutString_68K, 0);
}

