/*
PuTTY is copyright 1997-2004 Simon Tatham.

Portions copyright Robert de Bath, Joris van Rantwijk, Delian
Delchev, Andreas Schultz, Jeroen Massar, Wez Furlong, Nicolas Barry,
Justin Bradford, Ben Harris, and CORE SDI S.A.

Permission is hereby granted, free of charge, to any person
obtaining a copy of this software and associated documentation files
(the "Software"), to deal in the Software without restriction,
including without limitation the rights to use, copy, modify, merge,
publish, distribute, sublicense, and/or sell copies of the Software,
and to permit persons to whom the Software is furnished to do so,
subject to the following conditions:

The above copyright notice and this permission notice shall be
included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
NONINFRINGEMENT.  IN NO EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/
/**********
 * Portions Copyright (c) 2004 Greg Parker.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY GREG PARKER ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 **********/

#include "putty.h"
// #include "charset.h"
#include "terminal.h"
#include "misc.h"

/*
 * Palm Unicode-handling routines.
 * GrP fixme ISO 8859-1 only, not really unicode
 */

int is_dbcs_leadbyte(int codepage, char byte)
{
    return 0;			       /* we don't do DBCS */
}

// GrP fixme assumes multibyte is really single byte
size_t mb_to_wc(int codepage, int flags, char *mbstr, size_t mblen,
                wchar_t *wcstr, size_t wclen)
{
    size_t n = 0;
    while (mblen > 0) {
        wcstr[n] = (mbstr[0] & 0xFF);
        n++;
        mbstr++;
        mblen--;
    }
    return n;
}


// GrP fixme assumes multibyte is really single byte
size_t wc_to_mb(int codepage, int flags, wchar_t *wcstr, size_t wclen,
                char *mbstr, size_t mblen, char *defchr, int *defused,
                struct unicode_data *ucsdata)
{
    size_t n = 0;

    /* FIXME: we should remove the defused param completely... */
    if (defused)
	*defused = 0;

    while (wclen > 0 && n < mblen) {
        mbstr[n++] = (*wcstr & 0xFF);
        wcstr++;
        wclen--;
    }
    return n;
}

// GrP fixme use this for cut&paste
static const wchar_t unitab_xterm_poorman[32] = {
    '*','#','*','*','*','*','o','~','*','*','+','+','+','+','+','-',
    '-','-','-','-','+','+','+','+','|','*','*','*','*','L','.'
};
/*
 * Return value is TRUE if pterm is to run in direct-to-font mode.
 */
void init_ucs(struct unicode_data *ucsdata, int font_charset, int vtmode)
{
    int i;

    /*
     * In the platform-independent parts of the code, font_codepage
     * is used only for system DBCS support - which we don't
     * support at all. So we set this to something which will never
     * be used.
     */
    ucsdata->font_codepage = -1;

    ucsdata->line_codepage = font_charset;

    // GrP stripped unitab and charset goo except for unitab_ctrl
    // We use ISO 8859-1 only for now. 
    // note: Palm native charset is CP1252 except for two places 
    // (accented S and s). CP1252 is a superset of ISO-8859-1

    /*
     * Find the control characters in the line codepage. For
     * direct-to-font mode using the D800 hack, we assume 00-1F and
     * 7F are controls, but allow 80-9F through. (It's as good a
     * guess as anything; and my bet is that half the weird fonts
     * used in this way will be IBM or MS code pages anyway.)
     */
    // GrP no D800 hack
    for (i = 0; i < 256; i++) {
	unsigned int lineval = i;
	if (lineval < ' ' || (lineval >= 0x7F && lineval < 0xA0))
	    ucsdata->unitab_ctrl[i] = i;
	else
	    ucsdata->unitab_ctrl[i] = 0xFF;
    }
}
