/**********
 * Copyright (c) 2004 Greg Parker.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY GREG PARKER ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 **********/

#ifndef PUBLICKEYS_H
#define PUBLICKEYS_H

#include "includes.h"
#include "queue.h"
#include "data/recordlist.h"
#include "ssh/openssh/key.h"

Boolean PublicKeysInit(void) PUBLICKEYS_SEGMENT;
void PublicKeysFree(void) PUBLICKEYS_SEGMENT;
void PublicKeysUpdate(void) PUBLICKEYS_SEGMENT;
Boolean PublicKeysHandleEvent(EventPtr event) PUBLICKEYS_SEGMENT;

UInt16 PublicKeysSelectedIndex(void) PUBLICKEYS_SEGMENT;
void PublicKeysDeleteSelectedRecord(void) PUBLICKEYS_SEGMENT;
MemHandle PublicKeysQuerySelectedRecord(Boolean *encrypted, char **comment, uint8_t **pubkey, uint16_t *pubkeylen, uint8_t **privkey, uint16_t *privkeylen) PUBLICKEYS_SEGMENT;
MemHandle PublicKeysQueryIndexedRecord(UInt16 index, Boolean *encrypted, char **comment, uint8_t **pubkey, uint16_t *pubkeylen, uint8_t **privkey, uint16_t *privkeylen) PUBLICKEYS_SEGMENT;

Key *PublicKeyForRecord(MemPtr recordP) PUBLICKEYS_SEGMENT;
Key *PrivateKeyForRecord(MemPtr recordP, char *passphrase) PUBLICKEYS_SEGMENT;
char *NameForPublicKey(MemHandle recordH) PUBLICKEYS_SEGMENT;
queue_t *PhraselessPublicKeys(void) PUBLICKEYS_SEGMENT;
queue_t *PhrasefulPublicKeys(void) PUBLICKEYS_SEGMENT;

Boolean SaveImportedPublicKey(Boolean encrypted, 
                              char *comment, uint16_t commentlen,
                              Key *pubkey, 
                              char *privkey, uint16_t privkeylen)
     PUBLICKEYS_SEGMENT;
Boolean WritePublicKeyRecord(Boolean encrypted, 
                             char *comment, 
                             char *pubkey, uint16_t pubkeylen, 
                             char *privkey, uint16_t privkeylen)
     PUBLICKEYS_SEGMENT;

#endif
