/**********
 * Copyright (c) 2003-2004 Greg Parker.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY GREG PARKER ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 **********/

#include "includes.h"

#include "session.h"
#include "packetizer.h"
#include "ssh2.h"
#include "openssh/bufaux.h"
#include "xmalloc.h"

static void session_cleanup(ssh_session_t *ss) SSH_SEGMENT;

static void session_cleanup(ssh_session_t *ss)
{
    if (ss->s.socket >= 0) {
        close(ss->s.socket);
        // this print must only happen once
        printf("\r\nConnection closed.\r\n");
    }
    if (ss->s.hostname) arena_free(ss->s.hostname);
    if (ss->s.hostaddr) arena_free(ss->s.hostaddr);

    memset(&ss->s, 0, sizeof(ss->s));
    ss->s.socket = -1;
    ss->s.state = SESSION_STATE_CLOSED;
}

void session_kill(ssh_session_t *ss)
{
    if (ss->s.state != SESSION_STATE_CLOSED) {
        session_cleanup(ss);
    }
}


void session_close(ssh_session_t *ss)
{
    // clean shutdown is same as kill
    session_kill(ss);
}

int session_is_open(ssh_session_t *ss) 
{
    return (ss->s.state != SESSION_STATE_STARTING  &&  
            ss->s.state != SESSION_STATE_CLOSED);
}

int session_is_closing(ssh_session_t *ss)
{
    // session is never closing
    return 0;
}
