/**********
 * Copyright (c) 2003-2005 Greg Parker.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY GREG PARKER ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 **********/

#ifndef INCLUDES_H
#define INCLUDES_H


#define CRYPTO_SEGMENT  __attribute__ ((section ("crypto")))
#define CRYPTO2_SEGMENT  __attribute__ ((section ("crypto2")))
#define VT100_SEGMENT   __attribute__ ((section ("vt100")))
#define TERMINAL_SEGMENT   __attribute__ ((section ("terminal")))
#define SSH_SEGMENT     __attribute__ ((section ("ssh")))
#define FORMS_SEGMENT   __attribute__ ((section ("forms")))
#define SSH2_SEGMENT __attribute__ ((section ("ssh2")))
// no relation to ssh2 protocol


#define PACKETIZER_SEGMENT SSH2_SEGMENT
#define CONNECTION_SEGMENT SSH_SEGMENT
#define TRANSPORT_SEGMENT SSH2_SEGMENT
#define KEX_SEGMENT SSH_SEGMENT
#define SSHDH_SEGMENT SSH_SEGMENT
#define MAC_SEGMENT SSH_SEGMENT

#define OPENSSL_SEGMENT CRYPTO_SEGMENT
#define SHA_SEGMENT CRYPTO_SEGMENT
#define SHA2_SEGMENT CRYPTO_SEGMENT
#define AES_SEGMENT CRYPTO_SEGMENT
#define DES_SEGMENT CRYPTO_SEGMENT
#define EVP_SEGMENT CRYPTO_SEGMENT
#define DH_SEGMENT CRYPTO_SEGMENT
#define HMAC_SEGMENT CRYPTO_SEGMENT

#define RSA_SEGMENT CRYPTO2_SEGMENT
#define DSA_SEGMENT CRYPTO2_SEGMENT
#define FORTUNA_SEGMENT CRYPTO2_SEGMENT
#define RAND_SEGMENT CRYPTO2_SEGMENT
#define MD5_SEGMENT CRYPTO2_SEGMENT

#define DATA_SEGMENT CRYPTO2_SEGMENT
#define HOSTKEYS_SEGMENT DATA_SEGMENT
#define CONNECTIONLIST_SEGMENT DATA_SEGMENT
#define PUBLICKEYS_SEGMENT DATA_SEGMENT
#define RECORDLIST_SEGMENT DATA_SEGMENT

#define PUTTY_SEGMENT VT100_SEGMENT
#define CHARSET_SEGMENT VT100_SEGMENT

#define RESIZE_SECTION FORMS_SEGMENT
#define DIA_SECTION FORMS_SEGMENT

// Palm headers
#include <PalmOS.h>
#include <sys_types.h>
#include <sys_socket.h>
#include <unix_stdio.h>
#include <stdint.h>
#include "stdlib.h"

// undo definition from FloatMgr.h
#undef BIG_ENDIAN
#define BIG_ENDIAN 4321
#define LITTLE_ENDIAN 1234
#define BYTE_ORDER BIG_ENDIAN

// undo definitions from unix_string.h
#undef strcpy
#undef strncpy
#undef strcmp
#undef strcat
#undef strlen
#undef strchr
#undef strstr
#undef memcpy
#undef memset
#undef memcmp
#undef index

// prototypes for gcc builtins
extern char *strcpy(char *dst, const char *src);
extern char *strncpy(char *dst, const char *src, size_t len);
extern size_t strlen(const char *s);
extern char *strchr(const char *s, int c);
extern char *strrchr(const char *s, int c);
extern char *strstr(const char *big, const char *little);
extern void *memcpy(void *dst, const void *src, size_t len);
extern void *memset(void *b, int c, size_t len);
extern int strncmp(const char *s1, const char *s2, size_t len);
extern void *memmove(void *dst, const void *src, size_t len);
extern char *strcat(char *s, const char *append);
extern char *strncat(char *s, const char *append, size_t count);




// #define RCSID(str) static const char *rcs = str
#define RCSID(str) /* */

#ifndef MAX
# define MAX(a,b) (((a)>(b))?(a):(b))
# define MIN(a,b) (((a)<(b))?(a):(b))
#endif

#ifndef roundup
# define roundup(x, y)   ((((x)+((y)-1))/(y))*(y))
#endif


extern void complain(char *s);
extern void complain_int(char *err, uint32_t i);

static inline void noop() { }

// Define the following as debug_printf to get logging

// OpenSSH (fixme move somewhere else)
#define log noop
#define logit noop
#define debug1 noop
#define debug2 noop
#define debug3 noop
#define error fatal

// not OpenSSH
#define ssh_log noop
#define transport_log noop
#define packetizer_log noop
#define connection_log noop
#define fortuna_log noop
#define rand_log noop
#define vt100_log noop
#define kbdint_log noop
#define compress_log noop


typedef uint32_t u_int32_t;
typedef uint64_t u_int64_t;
typedef uint16_t wchar_t;
typedef int32_t ssize_t;

// custom event types
#define usrNetEvent (sysEventFirstUserEvent+0)
#define usrDrawVT100Event (sysEventFirstUserEvent+1)
#define usrDrawCloseBoxEvent (sysEventFirstUserEvent+2)
#define usrSetScrollBarEvent (sysEventFirstUserEvent+3)
#define usrSetFocusEvent (sysEventFirstUserEvent+4)

typedef struct {
    eventsEnum eType;
    Boolean penDown;
    UInt8 tapCount;
    Int16 screenX;
    Int16 screenY;
    union {
        struct _GenericEventType generic;
        struct {
            void *frontend;
            int16_t total;
            int16_t start;
            int16_t page;
        } sbar;
    } data;
} SetScrollBarEventType;

typedef struct {
    eventsEnum eType;
    Boolean penDown;
    UInt8 tapCount;
    Int16 screenX;
    Int16 screenY;
    union {
        struct _GenericEventType generic;
        struct {
            UInt16 id;
            FormPtr form;
        } focus;
    } data;
} SetFocusEventType;


// prototypes for main.c

Boolean ApplicationHandleEvent(EventPtr e) FORMS_SEGMENT;

#endif
