/**********
 * Copyright (c) 2003-2004 Greg Parker.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY GREG PARKER ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 **********/

#ifndef VT100_H
#define VT100_H

#include "includes.h"

struct display;  // ARM-only

// bounds is STANDARD-RESOLUTION
struct display *vt100_new(struct ssh_session_t *ss, 
                          RectangleType bounds) VT100_SEGMENT;

void vt100_free(struct display *disp) VT100_SEGMENT;

void vt100_write(struct display *disp, const char *bytes, size_t len) VT100_SEGMENT;

void vt100_update(struct display *disp) VT100_SEGMENT;

void vt100_task(struct display *disp) VT100_SEGMENT;

void vt100_scroll(struct display *disp, int lines) VT100_SEGMENT;

void vt100_activate(struct display *disp) VT100_SEGMENT;

void vt100_deactivate(struct display *disp) VT100_SEGMENT;

// in: bounds (STANDARD-RESOLUTION)
// out: charsWide and charsHigh
void vt100_set_bounds(struct display *disp, RectangleType bounds) VT100_SEGMENT;

// x and y are STANDARD-RESOLUTION
// clickCount is 1 or more for mouse down, 0 for mouse up
void vt100_click(struct display *disp, int x, int y, int clickCount) VT100_SEGMENT;

void vt100_deselect(struct display *disp) VT100_SEGMENT;

void vt100_copy(struct display *disp) VT100_SEGMENT;

void vt100_paste(struct display *disp) VT100_SEGMENT;

int vt100_selection_exists(struct display *disp) VT100_SEGMENT;

// bounds returned is NATIVE-RESOLUTION
void vt100_size(struct display *disp, int *charsWide, int *charsHigh, RectangleType *bounds) VT100_SEGMENT;

void vt100_reread_prefs(struct display *disp) VT100_SEGMENT;

void vt100_seen_key(struct display *disp) VT100_SEGMENT;

int vt100_app_cursor_keys(struct display *disp) VT100_SEGMENT; // fixme suck

#endif
