/**********
 * Copyright (c) 2003-2004 Greg Parker.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY GREG PARKER ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 **********/

#include "aes_internal.h"
#include "swap.h"

uint32_t AES_set_encrypt_key_stub(uint32_t *param);
uint32_t AES_set_decrypt_key_stub(uint32_t *param);
uint32_t AES_cbc_encrypt_stub(uint32_t *param);
uint32_t AES_encrypt_stub(uint32_t *param);

uint32_t AES_set_encrypt_key_stub(uint32_t *param) {
    unsigned char *userKey = (unsigned char *)read32(&param[0]);
    int bits = (int)read32(&param[1]);
    AES_KEY *key = (AES_KEY *)read32(&param[2]);

    return (uint32_t) AES_set_encrypt_key(userKey, bits, key);
}

uint32_t AES_set_decrypt_key_stub(uint32_t *param) {
    unsigned char *userKey = (unsigned char *)read32(&param[0]);
    int bits = (int)read32(&param[1]);
    AES_KEY *key = (AES_KEY *)read32(&param[2]);

    return (uint32_t) AES_set_decrypt_key(userKey, bits, key);
}

uint32_t AES_cbc_encrypt_stub(uint32_t *param) {
    unsigned char *in = (unsigned char *)read32(&param[0]);
    unsigned char *out = (unsigned char *)read32(&param[1]);
    uint32_t length = (uint32_t)read32(&param[2]);
    AES_KEY *key = (AES_KEY *)read32(&param[3]);
    unsigned char *ivec = (unsigned char *)read32(&param[4]);
    int enc = (int)read32(&param[5]);

    AES_cbc_encrypt(in, out, length, key, ivec, enc);
    return 0;
}

uint32_t AES_encrypt_stub(uint32_t *param) {
    unsigned char *in = (unsigned char *)read32(&param[0]);
    unsigned char *out = (unsigned char *)read32(&param[1]);
    AES_KEY *key = (AES_KEY *)read32(&param[2]);

    AES_encrypt(in, out, key);
    return 0;
}
