/**********
 * Copyright (c) 2004 Greg Parker.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY GREG PARKER ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 **********/


#ifndef PREFS_H
#define PREFS_H

#include "includes.h"

// Preference values
// NEVER CHANGE THESE, only add to them.

// non-terminal interface
#define prefEchoPassword 1 // boolean
#define prefTopPane 2      // int
#define prefBottomPane 3   // int
#define prefNoAutoOff 4    // unused
#define prefHideTitleBar 5 // boolean
#define prefHideInputArea 6 // boolean

// ssh
#define prefCipherAES128CBC 100 // boolean
#define prefCipher3DESCBC 101   // boolean
#define prefAuthPublicKey 102   // boolean
#define prefAuthPassword 103    // boolean
#define prefCompressZLib 104    // boolean

// basic terminal
#define prefTerminalType 200          // string
#define prefScrollbackLines 201       // int
#define prefScrollDownOnActivity 202  // boolean
#define prefScrollDownOnTyping 203    // boolean
#define prefTerminalFont 204          // int
#define prefTerminalForeColor 205     // int
#define prefTerminalBackColor 206     // int
#define prefBellBeep 207              // boolean
#define prefBellFlash 208             // boolean
#define prefBackspace 209           // boolean

// values for prefTerminalFont:
#define font4x6 1
#define font6x10 2
#define fontDefault font4x6


// values for prefTerminalFore/BackColor
#define blackColor   0
#define redColor     1
#define greenColor   2
#define yellowColor  3
#define blueColor    4
#define magentaColor 5
#define cyanColor    6
#define whiteColor   7
#define defaultForeColor blackColor
#define defaultBackColor whiteColor

// values for prefScrollbackLines
#define defaultScrollbackLines 500
#define maxScrollbackLines 9999

// values for bell
#define defaultBellBeep 1
#define defaultBellFlash 0

// values for scroll behavior
#define defaultScrollDownOnTyping 1
#define defaultScrollDownOnActivity 0

// values for compression
// fixme change to 1?
#define defaultCompressZLib 0

// value for backspace - default is DEL
#define backspaceDEL 0
#define backspaceBS 1
#define defaultBackspace backspaceDEL


int PrefsInit(void);
uint32_t PrefsGetInt(uint32_t which, uint32_t defaultValue);
void PrefsPutInt(uint32_t which, uint32_t value);

char *PrefsGetString(uint32_t which, char *defaultValue);
void PrefsPutString(uint32_t which, char *value);

#endif
