/**********
 * Copyright (c) 2004-2005 Greg Parker.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY GREG PARKER ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 **********/

#ifndef INCLUDES_H
#define INCLUDES_H

#include "stdint.h"
#include <stddef.h>
#include <stdarg.h>

// evil hack to avoid trap definitions
#define _STRUCTURE_PICTURES
#define __SPIC__(a, b, c, d)
#include <PalmOS.h>
#include <PceNativeCall.h>
#undef  _STRUCTURE_PICTURES
#undef  __SPIC__

#include "assert.h"
#include "stdlib.h"
#include "xmalloc.h"


// assorted types
typedef int32_t ssize_t;


// prototypes for gcc builtins
extern char *strcpy(char *dst, const char *src);
extern char *strncpy(char *dst, const char *src, size_t len);
extern size_t strlen(const char *s);
extern char *strchr(const char *s, int c);
extern char *strrchr(const char *s, int c);
extern char *strstr(const char *big, const char *little);
extern void *memcpy(void *dst, const void *src, size_t len);
extern void *memset(void *b, int c, size_t len);
extern int strncmp(const char *s1, const char *s2, size_t len);
extern void *memmove(void *dst, const void *src, size_t len);
extern char *strcat(char *s, const char *append);
extern char *strncat(char *s, const char *append, size_t count);
extern int memcmp(const void *b1, const void *b2, size_t len);


// misc definitions

#define RCSID(str) /* */

#ifndef MAX
# define MAX(a,b) (((a)>(b))?(a):(b))
# define MIN(a,b) (((a)<(b))?(a):(b))
#endif


// logging
static inline void noop() { }

#define fortuna_log noop
#define rand_log noop
#define vt100_log noop
#define vt100_log noop


// custom event types
#define usrNetEvent (sysEventFirstUserEvent+0)
#define usrDrawVT100Event (sysEventFirstUserEvent+1)
#define usrDrawCloseBoxEvent (sysEventFirstUserEvent+2)
#define usrSetScrollBarEvent (sysEventFirstUserEvent+3)

#pragma pack(push, 2)
typedef struct {
    uint16_t eType;
    Boolean penDown;
    UInt8 tapCount;
    Int16 screenX;
    Int16 screenY;
    union {
        struct _GenericEventType generic;
        struct {
            void *frontend;
            int16_t total;
            int16_t start;
            int16_t page;
        } sbar;
    } data;
} SetScrollBarEventType;
#pragma pack(pop)

#ifndef FALSE
#define FALSE 0
#define TRUE (!FALSE)
#endif


#endif
