#ifndef PACE_H
#define PACE_H

#include "includes.h"
#include "pealstub.h"
#include "swap.h"

typedef struct EmulStateType 
{
    uint32_t instr;
    uint32_t regD[8];
    uint32_t regA[8];
    uint32_t regPC;
} EmulStateType;

#define PACE_PARAMS \
uint8_t params[] 

#define PACE_PARAMS_ADD8(param) \
( (uint8_t)(param) & 0xff), 0,

#define PACE_PARAMS_ADD16(param) \
(((uint16_t)(param) >> 8) & 0xff), \
( (uint16_t)(param) & 0xff),

#define PACE_PARAMS_ADD32(param) \
(((uint32_t)(param) >> 24) & 0xff), \
(((uint32_t)(param) >> 16) & 0xff), \
(((uint32_t)(param) >> 8) & 0xff), \
( (uint32_t)(param) & 0xff),


#define PACE_EXEC_FN(fn, flag) \
gCall68KFuncP((void *)gEmulStateP, \
((unsigned long)fn), &params, sizeof(params) | (flag))

#define PACE_EXEC(trap, flag) \
gCall68KFuncP((void *)gEmulStateP, \
PceNativeTrapNo(sysTrap##trap), &params, sizeof(params) | (flag))

#define PACE_EXEC_SELECTOR(selector) \
((EmulStateType *)gEmulStateP)->regD[2] = selector

#endif
