#include "vt100.h"
#include "pealstub.h"
#include "swap.h"

uint32_t vt100_new_stub(uint32_t *param);
uint32_t vt100_free_stub(uint32_t *param);
uint32_t vt100_write_stub(uint32_t *param);
uint32_t vt100_update_stub(uint32_t *param);
uint32_t vt100_task_stub(uint32_t *param);
uint32_t vt100_scroll_stub(uint32_t *param);
uint32_t vt100_activate_stub(uint32_t *param);
uint32_t vt100_deactivate_stub(uint32_t *param);
uint32_t vt100_set_bounds_stub(uint32_t *param);
uint32_t vt100_click_stub(uint32_t *param);
uint32_t vt100_deselect_stub(uint32_t *param);
uint32_t vt100_copy_stub(uint32_t *param);
uint32_t vt100_paste_stub(uint32_t *param);
uint32_t vt100_selection_exists_stub(uint32_t *param);
uint32_t vt100_size_stub(uint32_t *param);
uint32_t vt100_reread_prefs_stub(uint32_t *param);
uint32_t vt100_seen_key_stub(uint32_t *param);
uint32_t vt100_app_cursor_keys_stub(uint32_t *param);
uint32_t font_for_screen_stub(uint32_t *param);
uint32_t set_palm_color_stub(uint32_t *param);


uint32_t vt100_new_stub(uint32_t *param) 
{
    struct ssh_session_t *ss = (struct ssh_session_t *)read32(&param[0]);
    RectangleType bounds = readRect(read32(&param[1]));
    return (uint32_t) vt100_new(ss, bounds);
}


uint32_t vt100_free_stub(uint32_t *param) 
{
    struct display *disp = (struct display *)read32(&param[0]);
    vt100_free(disp);
    return 0;
}


uint32_t vt100_write_stub(uint32_t *param) 
{
    struct display *disp = (struct display *)read32(&param[0]);
    const char *bytes = (const char *)read32(&param[1]);
    size_t len = (size_t)read32(&param[2]);
    vt100_write(disp, bytes, len);
    return 0;
}


uint32_t vt100_update_stub(uint32_t *param) 
{
    struct display *disp = (struct display *)read32(&param[0]);
    vt100_update(disp);
    return 0;
}


uint32_t vt100_task_stub(uint32_t *param) 
{
    struct display *disp = (struct display *)read32(&param[0]);
    vt100_task(disp);
    return 0;
}


uint32_t vt100_scroll_stub(uint32_t *param) 
{
    struct display *disp = (struct display *)read32(&param[0]);
    int lines = (int)read32(&param[1]);
    vt100_scroll(disp, lines);
    return 0;
}


uint32_t vt100_activate_stub(uint32_t *param) 
{
    struct display *disp = (struct display *)read32(&param[0]);
    vt100_activate(disp);
    return 0;
}


uint32_t vt100_deactivate_stub(uint32_t *param) 
{
    struct display *disp = (struct display *)read32(&param[0]);
    vt100_deactivate(disp);
    return 0;
}


uint32_t vt100_set_bounds_stub(uint32_t *param) 
{
    struct display *disp = (struct display *)read32(&param[0]);
    RectangleType bounds = readRect(read32(&param[1]));
    vt100_set_bounds(disp, bounds);
    return 0;
}


uint32_t vt100_click_stub(uint32_t *param) 
{
    struct display *disp = (struct display *)read32(&param[0]);
    int x = (int)read32(&param[1]);
    int y = (int)read32(&param[2]);
    int clickCount = (int)read32(&param[3]);
    vt100_click(disp, x, y, clickCount);
    return 0;
}


uint32_t vt100_deselect_stub(uint32_t *param) 
{
    struct display *disp = (struct display *)read32(&param[0]);
    vt100_deselect(disp);
    return 0;
}


uint32_t vt100_copy_stub(uint32_t *param) 
{
    struct display *disp = (struct display *)read32(&param[0]);
    vt100_copy(disp);
    return 0;
}


uint32_t vt100_paste_stub(uint32_t *param) 
{
    struct display *disp = (struct display *)read32(&param[0]);
    vt100_paste(disp);
    return 0;
}


uint32_t vt100_selection_exists_stub(uint32_t *param) 
{
    struct display *disp = (struct display *)read32(&param[0]);
    return (uint32_t) vt100_selection_exists(disp);
}


uint32_t vt100_size_stub(uint32_t *param) 
{
    struct display *disp = (struct display *)read32(&param[0]);
    int16_t *charsWideP = (int16_t *)read32(&param[1]);
    int16_t *charsHighP = (int16_t *)read32(&param[2]);
    RectangleType *boundsP = (RectangleType *)read32(&param[3]);

    RectangleType bounds;
    int charsWide;
    int charsHigh;

    if (charsWideP) charsWide = read16(charsWideP);
    if (charsHighP) charsHigh = read16(charsHighP);
    if (boundsP) bounds = readRect(boundsP);

    vt100_size(disp, 
               charsWideP ? &charsWide : NULL, 
               charsHighP ? &charsHigh : NULL, 
               boundsP ? &bounds : NULL);

    if (charsWideP) write16(charsWideP, charsWide);
    if (charsHighP) write16(charsHighP, charsHigh);
    if (boundsP) writeRect(boundsP, bounds);

    return 0;
}


uint32_t vt100_reread_prefs_stub(uint32_t *param) 
{
    struct display *disp = (struct display *)read32(&param[0]);
    vt100_reread_prefs(disp);
    return 0;
}


uint32_t vt100_seen_key_stub(uint32_t *param) 
{
    struct display *disp = (struct display *)read32(&param[0]);
    vt100_seen_key(disp);
    return 0;
}


uint32_t vt100_app_cursor_keys_stub(uint32_t *param) 
{
    struct display *disp = (struct display *)read32(&param[0]);
    return (uint32_t) vt100_app_cursor_keys(disp);
}


uint32_t font_for_screen_stub(uint32_t *param) 
{
    int fontPref = (int)read32(&param[0]);
    return (uint32_t) font_for_screen(fontPref);
}


uint32_t set_palm_color_stub(uint32_t *param) 
{
    int fg_color = (int)read32(&param[0]);
    int bg_color = (int)read32(&param[1]);
    set_palm_color(fg_color, bg_color);
    return 0;
}

