/**********
 * Copyright (c) 2003-2004 Greg Parker.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY GREG PARKER ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 **********/

#include "includes.h"
#include "aes.h"
#include "aes_armstubs.h"
#include "armstubs.h"


int AES_set_encrypt_key(const unsigned char *userKey, const int bits,
                        AES_KEY *key) 
{
    static void *addr = NULL;
    uint32_t result;
    uint32_t param[3];
    param[0] = (uint32_t)userKey;
    param[1] = (uint32_t)bits;
    param[2] = (uint32_t)key;

    if (!addr) addr = PealLookupSymbol(arm_module, __FUNCTION__ "_stub");
    if (!addr) fatal("no ARM symbol %s", __FUNCTION__ "_stub");

    result = PealCall(arm_module, addr, param);

    return (int)result;
}


int AES_set_decrypt_key(const unsigned char *userKey, const int bits,
                        AES_KEY *key) 
{
    static void *addr = NULL;
    uint32_t result;
    uint32_t param[3];
    param[0] = (uint32_t)userKey;
    param[1] = (uint32_t)bits;
    param[2] = (uint32_t)key;

    if (!addr) addr = PealLookupSymbol(arm_module, __FUNCTION__ "_stub");
    if (!addr) fatal("no ARM symbol %s", __FUNCTION__ "_stub");
    
    result = PealCall(arm_module, addr, param);

    return (int)result;
}


void AES_cbc_encrypt(const unsigned char *in, unsigned char *out,
                     const uint32_t length, const AES_KEY *key,
                     unsigned char *ivec, const int enc) 
{
    static void *addr = NULL;
    uint32_t param[6];
    param[0] = (uint32_t)in;
    param[1] = (uint32_t)out;
    param[2] = (uint32_t)length;
    param[3] = (uint32_t)key;
    param[4] = (uint32_t)ivec;
    param[5] = (uint32_t)enc;

    if (!addr) addr = PealLookupSymbol(arm_module, __FUNCTION__ "_stub");
    if (!addr) fatal("no ARM symbol %s", __FUNCTION__ "_stub");
    
    PealCall(arm_module, addr, param);
}

void AES_encrypt(const unsigned char *in, unsigned char *out,
                 const AES_KEY *key) 
{
    static void *addr = NULL;
    uint32_t param[3];
    param[0] = (uint32_t)in;
    param[1] = (uint32_t)out;
    param[2] = (uint32_t)key;

    if (!addr) addr = PealLookupSymbol(arm_module, __FUNCTION__ "_stub");
    if (!addr) fatal("no ARM symbol %s", __FUNCTION__ "_stub");
    
    PealCall(arm_module, addr, param);
}
