/**********
 * Copyright (c) 2003-2004 Greg Parker.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY GREG PARKER ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 **********/

#ifndef HOSTKEYS_H
#define HOSTKEYS_H

#include "includes.h"
#include "data/recordlist.h"
#include "ssh/openssh/key.h"

void HostKeysFree(void) HOSTKEYS_SEGMENT;
Boolean HostKeysInit(void) HOSTKEYS_SEGMENT;

void HostKeysUpdate(void) HOSTKEYS_SEGMENT;
Boolean HostKeysHandleEvent(EventPtr event) HOSTKEYS_SEGMENT;

UInt16 HostKeysSelectedIndex(void) HOSTKEYS_SEGMENT;

MemHandle HostKeysQueryIndexedRecord(UInt16 index, char **hostnames, uint8_t **keyblob, uint16_t *keybloblen) HOSTKEYS_SEGMENT;
MemHandle HostKeysQuerySelectedRecord(char **hostnames, uint8_t **keyblob, uint16_t *keybloblen) HOSTKEYS_SEGMENT;
void HostKeysDeleteSelectedRecord(void) HOSTKEYS_SEGMENT;

UInt16 HostKeysFindRecordForHostname(const char *hostname) HOSTKEYS_SEGMENT;
UInt16 HostKeysFindRecordForKey(Key *hostkey) HOSTKEYS_SEGMENT;

Boolean HostKeysAddRecord(const char *hostname, Key *hostkey) HOSTKEYS_SEGMENT;
Boolean HostKeysAddHostnameToRecord(const char *hostname, UInt16 index) HOSTKEYS_SEGMENT;
Boolean HostKeysRemoveHostnameFromRecord(const char *hostname, UInt16 index) HOSTKEYS_SEGMENT;

#endif
