/**********
 * Copyright (c) 2003-2005 Greg Parker.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY GREG PARKER ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 **********/

#include "includes.h"
#include "formutils.h"
#include "data/connectionlist.h"
#include "rsrc/rsrc.h"
#include "forms/resize.h"

#include "loginform.h"


static Boolean ValidateLoginForm(void) FORMS_SEGMENT;
static Boolean SaveLoginForm(void) FORMS_SEGMENT;
static void LoadEmptyLoginForm(void) FORMS_SEGMENT;


static Boolean ValidateLoginForm(void)
{
    return true; // fixme
}


// returns FALSE if save failed for some reason
// if save fails, caller shouldn't connect
static Boolean SaveLoginForm(void)
{
    FieldPtr hostFld = PrvGetObjectByID(LoginFormHostFieldID);
    FieldPtr portFld = PrvGetObjectByID(LoginFormPortFieldID);
    FieldPtr userFld = PrvGetObjectByID(LoginFormUsernameFieldID);

    if (FldDirty(hostFld)  ||  FldDirty(portFld)  ||  FldDirty(userFld)) {
        return ConnectionListWriteSelectedRecord(hostFld, portFld, userFld);
    } else {
        return true;
    }
}


static void LoadEmptyLoginForm(void)
{
    // set port field to default value; leave others empty
    PrvSetFieldToValueByID(LoginFormPortFieldID, "22");
    PrvSetFocusByID(LoginFormHostFieldID);
}


Boolean LoginFormHandleEvent(EventPtr e)
{
    FormPtr frmP = FrmGetActiveForm();

    if (ResizeHandleEvent(e)) return true;

    switch (e->eType) {
    case frmOpenEvent: {
        // "Connect" with nothing selected, or "New..."
        LoadEmptyLoginForm();
        FrmDrawForm(frmP);
        return true;
    }

    case ctlSelectEvent:
        switch (e->data.ctlSelect.controlID) {
        case LoginFormConnectButtonID:
            // make sure form data is good enough to use for a connection
            if (!ValidateLoginForm()) break;
            // Clear selection as late as possible
            ConnectionListClearSelection();
            if (SaveLoginForm()) {
                // login info saved to ConnectionList selected record
                // go to TerminalForm which will initiate connection
                FrmReturnToForm(0);
                FrmGotoForm(TerminalFormID);
            } else {
                // failed to save login info
                // fixme
                FrmReturnToForm(0);
            }
            break;

        case LoginFormCancelButtonID:
            // return to main form
            FrmReturnToForm(0);
            break;

        case LoginFormSaveButtonID:
            // save login info, return to main form
            // Don't validate - let the user enter anything
            ConnectionListClearSelection();
            if (!SaveLoginForm()) {
                // failed to save login info
                // fixme
            }
            FrmReturnToForm(0);
            break;

        default:
            break;
        }

        return true;

    case frmCloseEvent:
        return false;

    case usrSetFocusEvent:
        PrvReallySetFocus(frmP, e);
        return true;

    default: 
        return false;
    }
}
