/**********
 * Copyright (c) 2003-2005 Greg Parker.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY GREG PARKER ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 **********/

#include "includes.h"
#include "about.h"
#include "formutils.h"
#include "forms/resize.h"
#include "data/connectionlist.h"
#include "rsrc/rsrc.h"

#include "mainform.h"




Boolean MainFormHandleEvent(EventPtr e)
{
    FormPtr frmP = FrmGetActiveForm();

    if (ResizeHandleEvent(e)) return true;
    if (ConnectionListHandleEvent(e)) return true;

    switch (e->eType) {
    case frmOpenEvent:
        ConnectionListUpdate();
        FrmDrawForm(frmP);
        return true;

    case menuEvent:
        switch (e->data.menu.itemID) {
        case MenuConnect:
            if (ConnectionListSelectedIndex() == noRecord) {
                FrmPopupForm(LoginFormID);
            } else {
                FrmGotoForm(TerminalFormID);
            }
            return true;
        case MenuHostKeys:
            FrmPopupForm(HostKeysFormID);
            return true;
        case MenuAboutPalmSSH:
            FrmPopupForm(AboutFormID);
            return true;
        case MenuCredits:
            FrmPopupForm(CreditsFormID);
            return true;
        case MenuDisplaySettings:
            FrmPopupForm(DisplayPrefsFormID);
            return true;
        case MenuConnectionSettings:
            FrmPopupForm(ConnectionPrefsFormID);
            return true;
        case MenuKeyboardSettings:
            FrmPopupForm(KeyboardPrefsFormID);
            return true;
        case MenuPublicKeys:
            FrmPopupForm(PublicKeysFormID);
            return true;
        default:
            return false;
        }

    case ctlSelectEvent:
        switch (e->data.ctlSelect.controlID) {
        case MainConnectButtonID:
            if (ConnectionListSelectedIndex() == noRecord) {
                FrmPopupForm(LoginFormID);
            } else {
                FrmGotoForm(TerminalFormID);
            }
            break;

        case MainNewButtonID:
            FrmPopupForm(LoginFormID);
            break;

        case MainDetailsButtonID:
            if (ConnectionListSelectedIndex() != noRecord) {
                FrmPopupForm(DetailsFormID);
            }
            break;
        }
        return false;

    case frmCloseEvent:
        return false;

    default: 
        return false;
    }
}


void MainFormResize(FormPtr frmP, Int16 dh, Int16 dv)
{
    static Int16 height = -1;
    PrvResizeTableAndScrollbar(frmP, dh, dv, 0, &height, 
                               FrmGetObjectIndex(frmP, MainConnectionTableID), 
                               FrmGetObjectIndex(frmP, MainConnectionScrollbarID));

    ConnectionListUpdate();
}
