/**********
 * Copyright (c) 2003-2005 Greg Parker.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY GREG PARKER ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 **********/

#define PSSH_VERSION "2007-03-18-ARS"
#define PSSH_UVERSION "2007_03_18_ARS"

#define PSSH_CREATOR 'GPss'

#define ftrEntropy 1  // entropy cache
#define ftrEntropyWarning 2  // warned about crappy RNG?
#define ftrSecurityWarning 3 // warned about pssh insecurity?

#define MainMenuBar                                        1000
#define TerminalMenuBar                                    1001

#define MenuAboutPalmSSH                                   1000
#define MenuConnect                                        1001
#define MenuHostKeys                                       1002
#define MenuDisconnect                                     1003
#define MenuClearScrollback                                1004
#define MenuCredits                                        1005
#define MenuPublicKeys                                     1006
#define MenuTCKeyboard                                     1007
#define MenuDisplaySettings                                1008
#define MenuConnectionSettings                             1009
#define MenuToggleTitle                                    1010
#define MenuToggleInputArea                                1011
#define MenuCtrl                                           1012
#define MenuEsc                                            1013
#define MenuKeyboardSettings                               1014
#define MenuNoKeyboard                                     1015
#define MenuToggleStatusBar                                1016


#define NanoFontDoubleID                                   200
#define NanoFontSingleID                                   201
#define MediumFontDoubleID                                 202
#define MediumFontSingleID                                 203
#define PasswordFontID                                     204


#define MainFormID                                         1000
#define MainConnectButtonID 1001
#define MainNewButtonID 1002
#define MainDetailsButtonID 1003
#define MainConnectionTableID 1004
#define MainConnectionScrollbarID 1005

#define AboutFormID                                        1100
#define AboutFormOKButtonID                                1101

// 1200..1299 Terminal graphical button bitmaps
#define TerminalCloseBoxBitmapID 1200
#define TerminalCloseBoxSelectedBitmapID 1201
#define TerminalRScrollLineUpBitmapID 1202
#define TerminalRScrollLineUpSelectedBitmapID 1203
#define TerminalRScrollLineUpDisabledBitmapID 1204
#define TerminalRScrollLineDownBitmapID 1205
#define TerminalRScrollLineDownSelectedBitmapID 1206
#define TerminalRScrollLineDownDisabledBitmapID 1207
#define TerminalRScrollPageUpBitmapID 1208
#define TerminalRScrollPageUpSelectedBitmapID 1209
#define TerminalRScrollPageUpDisabledBitmapID 1210
#define TerminalRScrollPageDownBitmapID 1211
#define TerminalRScrollPageDownSelectedBitmapID 1212
#define TerminalRScrollPageDownDisabledBitmapID 1213
#define TerminalAltPressedBitmapID 1214
#define TerminalAltLockedBitmapID 1215

#define TerminalFormID 1300
// 1300-1305 Controls present on all Terminal form flavors
#define TerminalCtrlButtonID 1301
#define TerminalMetaButtonID 1302
#define TerminalTextGadgetID 1303
#define TerminalHostFieldID 1304
#define TerminalCloseBoxButtonID 1305

// RArrows: Right side is arrow keys (harware keys are scolling)
// fixme unimplemented

// 1306-1329 RScroll: Right side is scrolling (hardware keys are arrow keys)
#define TerminalRScrollLineUpButtonID 1306
#define TerminalRScrollLineDownButtonID 1310
#define TerminalRScrollPageUpButtonID 1314
#define TerminalRScrollPageDownButtonID 1318

// 1330-1349 BTC: Bottom side is all 15 ASCII chars not on Tungsten C keyboard
// This set is also used for Treo 600, with '&' changed to '_'
#define TerminalBTCButtonsBitmapID 1330
// 15 self-labeled buttons, one of which is changed between T|C and Treo 600
#define TerminalBTCFirstButtonID 1331
#define TerminalBTCAmpersandButtonID TerminalBTCFirstButtonID+4
#define TerminalBTCLastButtonID 1345

// 1350-1374 BFull: Bottom side is scroll arrows and full-keyboard selectors
#define TerminalBFullABCButtonID 1350
#define TerminalBFull123ButtonID 1351
#define TerminalBFullIntlButtonID 1352
#define TerminalBFullEtcButtonID 1353
#define TerminalBFullUpButtonID 1354
#define TerminalBFullDownButtonID 1355
#define TerminalBFullLeftButtonID 1356
#define TerminalBFullRightButtonID 1357
#define TerminalBFullUpBitmapID 1358
#define TerminalBFullDownBitmapID 1359
#define TerminalBFullLeftBitmapID 1360
#define TerminalBFullRightBitmapID 1361
#define TerminalBFullUpSelectedBitmapID 1362
#define TerminalBFullDownSelectedBitmapID 1363
#define TerminalBFullLeftSelectedBitmapID 1364
#define TerminalBFullRightSelectedBitmapID 1365

// TNone: Top side is full-size vt100
// No additional controls

// 1375-1449 TABC: Top side is QWERTY keyboard
#define TerminalTABCButtonsBitmapID 1375
// 26 self-labeled lowercase letters
#define TerminalTABCFirstAlphaButtonID 1376
#define TerminalTABCLastAlphaButtonID 1401
// 6 self-labeled punctuation
#define TerminalTABCFirstPunctButtonID 1402
#define TerminalTABCLastPunctButtonID 1407
// 26 self-labeled uppercase letters
#define TerminalTABCFirstALPHAButtonID 1408
#define TerminalTABCLastALPHAButtonID 1433
// 6 self-labeled shifted punctuation
#define TerminalTABCFirstPUNCTButtonID 1434
#define TerminalTABCLastPUNCTButtonID 1439
// 6 non-self-labeled buttons
#define TerminalTABCTabButtonID 1440
#define TerminalTABCCapsButtonID 1441
#define TerminalTABCShiftButtonID 1442
#define TerminalTABCSpaceButtonID 1443
#define TerminalTABCBackspaceButtonID 1444
#define TerminalTABCReturnButtonID 1445

// button ranges: all, lower, upper, caps (upper alpha but lower punct)
#define TerminalTABCFirstButtonID TerminalTABCFirstAlphaButtonID
#define TerminalTABCLastButtonID TerminalTABCLastPUNCTButtonID
#define TerminalTABCFirstLowercaseButtonID TerminalTABCFirstAlphaButtonID
#define TerminalTABCLastLowercaseButtonID TerminalTABCLastPunctButtonID
#define TerminalTABCFirstUppercaseButtonID TerminalTABCFirstALPHAButtonID
#define TerminalTABCLastUppercaseButtonID TerminalTABCLastPUNCTButtonID
#define TerminalTABCFirstCapscaseButtonID TerminalTABCFirstPunctButtonID
#define TerminalTABCLastCapscaseButtonID TerminalTABCLastALPHAButtonID

// 1450-1499 T123: Top side is number pad and symbols
#define TerminalT123ButtonsBitmapID 1450
// 44 self-labeled buttons
#define TerminalT123FirstButtonID 1451
#define TerminalT123LastButtonID 1494
// 4 non-self-labeled buttons
#define TerminalT123BackspaceButtonID 1495
#define TerminalT123TabButtonID 1496
#define TerminalT123ReturnButtonID 1497
#define TerminalT123SpaceButtonID 1498

// 1500-1574 TIntl: Top side is accented characters
// Some of these controls are shared with the ABC pane
#define TerminalTIntlButtonsBitmapID TerminalTABCButtonsBitmapID
// 32 self-labeled lowercase letters
#define TerminalTIntlFirstLowercaseButtonID 1501
#define TerminalTIntlLastLowercaseButtonID 1532
// 32 self-labeled uppercase letters
#define TerminalTIntlFirstUppercaseButtonID 1533
#define TerminalTIntlLastUppercaseButtonID 1564
#define TerminalTIntlFirstButtonID TerminalTIntlFirstLowercaseButtonID
#define TerminalTIntlLastButtonID TerminalTIntlLastUppercaseButtonID
// 6 non-self-labeled buttons
#define TerminalTIntlTabButtonID TerminalTABCTabButtonID
#define TerminalTIntlCapsButtonID TerminalTABCCapsButtonID
#define TerminalTIntlShiftButtonID TerminalTABCShiftButtonID
#define TerminalTIntlSpaceButtonID TerminalTABCSpaceButtonID
#define TerminalTIntlBackspaceButtonID TerminalTABCBackspaceButtonID
#define TerminalTIntlReturnButtonID TerminalTABCReturnButtonID


// 1575-1650 TEtc: Top side is function keys, scroll pad, and misc Latin 1
// Some of these controls are shared with the ABC pane
#define TerminalTEtcButtonsBitmapID 1575
// 16 self-labeled "lowercase" Latin 1 characters
#define TerminalTEtcFirstLowercaseLatin1ButtonID 1576
#define TerminalTEtcLastLowercaseLatin1ButtonID 1591
// 16 self-labeled "uppercase" Latin 1 characters
#define TerminalTEtcFirstUppercaseLatin1ButtonID 1592
#define TerminalTEtcLastUppercaseLatin1ButtonID 1607
// 10 "lowercase" FKeys F1..F10
#define TerminalTEtcFirstLowercaseFKeyButtonID 1608
#define TerminalTEtcLastLowercaseFKeyButtonID 1617
// 10 "uppercase" FKeys F11..F20
#define TerminalTEtcFirstUppercaseFKeyButtonID 1618
#define TerminalTEtcLastUppercaseFKeyButtonID 1627
// 6 scroll pad keys (ordered by emulation code; do not reorder!)
#define TerminalTEtcHomeButtonID 1628
#define TerminalTEtcInsButtonID 1629
#define TerminalTEtcDelButtonID 1630
#define TerminalTEtcEndButtonID 1631
#define TerminalTEtcPgUpButtonID 1632
#define TerminalTEtcPgDnButtonID 1633
// 1 shift key
#define TerminalTEtcShiftButtonID TerminalTABCShiftButtonID
// ranges
// self-labeled and FKeys are each contiguous, but lower and uppercase are not
#define TerminalTEtcFirstButtonID TerminalTEtcFirstLowercaseLatin1ButtonID
#define TerminalTEtcLastButtonID  TerminalTEtcLastUppercaseFKeyButtonID
#define TerminalTEtcFirstLatin1ButtonID TerminalTEtcFirstLowercaseLatin1ButtonID
#define TerminalTEtcLastLatin1ButtonID  TerminalTEtcLastUppercaseLatin1ButtonID
#define TerminalTEtcFirstFKeyButtonID TerminalTEtcFirstLowercaseFKeyButtonID
#define TerminalTEtcLastFKeyButtonID  TerminalTEtcLastUppercaseFKeyButtonID


#define HostKeysFormID 1800
#define HostKeysFormOKButtonID 1801
#define HostKeysFormDetailsButtonID 1802
#define HostKeysFormKeyTableID 1803
#define HostKeysFormKeyScrollbarID 1804

#define HostKeyWarningFormID 1900
#define HostKeyWarningFormRejectButtonID 1901
#define HostKeyWarningFormTrustOnceButtonID 1902
#define HostKeyWarningFormTrustForeverButtonID 1903
#define HostKeyWarningFormContentFieldID 1904
#define HostKeyWarningFormAddressFieldID 1905

#define HostKeyDetailsFormID 2000
#define HostKeyDetailsFormOKButtonID 2001
#define HostKeyDetailsFormDeleteButtonID 2002
#define HostKeyDetailsFormHostFieldID 2003
#define HostKeyDetailsFormKeyTypeFieldID 2004
#define HostKeyDetailsFormKeyFieldID 2005
#define HostKeyDetailsFormKeyScrollbarID 2006

#define CreditsFormID 2100
#define CreditsFormFieldID 2101
#define CreditsFormScrollbarID 2102
#define CreditsFormOKButtonID 2103

#define DisplayPrefsFormID 2200
#define DisplayPrefsFormOKButtonID 2201
#define DisplayPrefsFormCancelButtonID 2202
#define DisplayPrefsFormSmallFontCheckboxID 2203
#define DisplayPrefsFormLargeFontCheckboxID 2204
#define DisplayPrefsFormForeColorTriggerID 2205
#define DisplayPrefsFormBackColorTriggerID 2206
#define DisplayPrefsFormForeColorListID 2207
#define DisplayPrefsFormBackColorListID 2208
#define DisplayPrefsFormSampleTextGadgetID 2209
#define DisplayPrefsFormScrollbackFieldID 2210
#define DisplayPrefsFormActivityCheckboxID 2211
#define DisplayPrefsFormTypingCheckboxID 2212
#define DisplayPrefsFormBeepCheckboxID 2213
#define DisplayPrefsFormFlashCheckboxID 2214

#define MemoFormID 2300
#define MemoFormImportButtonID 2301
#define MemoFormCancelButtonID 2302
#define MemoFormTableID 2303
#define MemoFormScrollbarID 2304

#define PublicKeysFormID 2400
#define PublicKeysFormOKButtonID 2401
#define PublicKeysFormDetailsButtonID 2402
#define PublicKeysFormImportButtonID 2403
#define PublicKeysFormKeyTableID 2404
#define PublicKeysFormKeyScrollbarID 2405

#define PublicKeyDetailsFormID 2500
#define PublicKeyDetailsFormOKButtonID 2501
#define PublicKeyDetailsFormCancelButtonID 2502
#define PublicKeyDetailsFormDeleteButtonID 2503
#define PublicKeyDetailsFormCommentFieldID 2504
#define PublicKeyDetailsFormKeyTypeFieldID 2505
#define PublicKeyDetailsFormKeyFieldID 2506
#define PublicKeyDetailsFormKeyScrollbarID 2507

#define PassphraseFormID 2600
#define PassphraseFormOKButtonID 2601
#define PassphraseFormCancelButtonID 2602
#define PassphraseFormMessageFieldID 2603
#define PassphraseFormPassphraseFieldID 2604
#define PassphraseFormEchoCheckboxID 2605

#define PublicKeyChoiceFormID 2700
#define PublicKeyChoiceFormOKButtonID 2701
#define PublicKeyChoiceFormCancelButtonID 2702
#define PublicKeyChoiceFormHostFieldID 2703
#define PublicKeyChoiceFormUsernameFieldID 2704
#define PublicKeyChoiceFormPassphraseFieldID 2705
#define PublicKeyChoiceFormEchoCheckboxID 2706
#define PublicKeyChoiceFormKeyListID 2707
#define PublicKeyChoiceFormKeyTriggerID 2708

#define ConnectionPrefsFormID 2800
#define ConnectionPrefsFormOKButtonID 2801
#define ConnectionPrefsFormCancelButtonID 2802
#define ConnectionPrefsFormAESCheckboxID 2803
#define ConnectionPrefsForm3DESCheckboxID 2804
#define ConnectionPrefsFormPublicKeyCheckboxID 2805
#define ConnectionPrefsFormPasswordCheckboxID 2806
#define ConnectionPrefsFormKbdIntCheckboxID 2807
#define ConnectionPrefsFormZLibCheckboxID 2808
#define ConnectionPrefsFormTerminalFieldID 2809
#define ConnectionPrefsFormTerminalTriggerID 2810
#define ConnectionPrefsFormTerminalListID 2811

#define LoginFormID 2900
#define LoginFormConnectButtonID 2901
#define LoginFormCancelButtonID 2902
#define LoginFormSaveButtonID 2903
#define LoginFormHostFieldID 2904
#define LoginFormPortFieldID 2905
#define LoginFormUsernameFieldID 2906

#define BannerFormID 3000
#define BannerFormFieldID 3001
#define BannerFormScrollbarID 3002
#define BannerFormOKButtonID 3003

#define PasswordFormID 3100
#define PasswordFormOKButtonID 3101
#define PasswordFormCancelButtonID 3102
#define PasswordFormHostFieldID 3103
#define PasswordFormUsernameFieldID 3104
#define PasswordFormPasswordFieldID 3105
#define PasswordFormEchoCheckboxID 3106

#define DetailsFormID 3200
#define DetailsFormOKButtonID 3201
#define DetailsFormCancelButtonID 3202
#define DetailsFormDeleteButtonID 3203
#define DetailsFormHostFieldID 3204
#define DetailsFormPortFieldID 3205
#define DetailsFormUsernameFieldID 3206

#define KeyboardPrefsFormID 3300
#define KeyboardPrefsFormOKButtonID 3301
#define KeyboardPrefsFormCancelButtonID 3302
#define KeyboardPrefsFormBackspaceDELCheckboxID 3303
#define KeyboardPrefsFormBackspaceBSCheckboxID 3304
#define KeyboardPrefsFormBackquoteNormalCheckboxID 3305
#define KeyboardPrefsFormBackquoteESCCheckboxID 3306

// This order is significant; see ShortenForm() in kbdintform.c
#define KbdIntFormID 3400
#define KbdIntFormHostLabelID 3401
#define KbdIntFormHostFieldID 3402
#define KbdIntFormInstructionFieldID 3403
#define KbdIntFormInstructionScrollbarID 3404
#define KbdIntFormPromptFieldID 3405
#define KbdIntFormResponseFieldID 3406
#define KbdIntFormEchoCheckboxID 3407
#define KbdIntFormProgressFieldID 3408
#define KbdIntFormNextButtonID 3409
#define KbdIntFormBackButtonID 3410
#define KbdIntFormCancelButtonID 3411
#define KbdIntFormLastID 3411

// This order is significant; see ShortenForm() in kbdint0form.c
#define KbdInt0FormID 3500
#define KbdInt0FormHostLabelID 3501
#define KbdInt0FormHostFieldID 3502
#define KbdInt0FormInstructionFieldID 3503
#define KbdInt0FormInstructionScrollbarID 3504
#define KbdInt0FormOKButtonID 3505
#define KbdInt0FormCancelButtonID 3506
#define KbdInt0FormLastID 3506

#define DeleteConnectionAlertID 6000
#define DeleteHostKeyAlertID 6100
#define AlertFormID 6200
#define FatalAlertID 6300
#define NetworkErrorAlertID 6400
#define DeletePublicKeyAlertID 6500

#define ResizeDataID 999
