/**********
 * Copyright (c) 2003-2004 Greg Parker.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY GREG PARKER ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 **********/

#ifndef CONNECTION_H
#define CONNECTION_H

#include "includes.h"
#include "session.h"
#include "openssh/buffer.h"

void connection_use_password(ssh_session_t *ss, char *username, char *password) CONNECTION_SEGMENT;
Boolean connection_use_passphrase(ssh_session_t *ss, char *username, char *passphrase, MemHandle pubkey) CONNECTION_SEGMENT;
void connection_use_kbdint(ssh_session_t *ss, char **responses) CONNECTION_SEGMENT;
void connection_use_bounds(ssh_session_t *ss, RectangleType bounds, int charsWide, int charsHigh) CONNECTION_SEGMENT;
void connection_receive_packet(ssh_session_t *ss, uint8_t msg, Buffer *packet) CONNECTION_SEGMENT;
void connection_send_data(ssh_session_t *ss, uint8_t *bytes, uint16_t len) CONNECTION_SEGMENT;
void connection_start(ssh_session_t *ss) CONNECTION_SEGMENT;
int connection_is_open(ssh_session_t *ss) CONNECTION_SEGMENT;
int connection_is_closing(ssh_session_t *ss) CONNECTION_SEGMENT;
void connection_close(ssh_session_t *ss) CONNECTION_SEGMENT;
void connection_kill(ssh_session_t *ss) CONNECTION_SEGMENT;

#endif
