/**********
 * Copyright (c) 2003-2004 Greg Parker.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY GREG PARKER ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 **********/

#ifndef SSH_H
#define SSH_H

#include "includes.h"
#include "queue.h"

struct ssh_session_t;

typedef struct prompt_t {
    char *msg;
    int echo;
} prompt_t;

struct ssh_session_t *ssh_get_current(void);

// ctor and dtor
struct ssh_session_t *ssh_create(char *username, RectangleType bounds) SSH_SEGMENT;
void ssh_free(struct ssh_session_t *ss) SSH_SEGMENT;

// connection management
int ssh_open(struct ssh_session_t *ss, char *hostname, int port) SSH_SEGMENT;
void ssh_close(struct ssh_session_t *ss) SSH_SEGMENT;
void ssh_kill(struct ssh_session_t *ss) SSH_SEGMENT;
int ssh_is_closed(struct ssh_session_t *ss) SSH_SEGMENT;

// data management
int ssh_request_select(struct ssh_session_t *ss, fd_set *rfds, fd_set *wfds) SSH_SEGMENT;
int ssh_is_selected(struct ssh_session_t *ss, fd_set *fds) SSH_SEGMENT;
void ssh_read(struct ssh_session_t *ss) SSH_SEGMENT;
void ssh_write(struct ssh_session_t *ss) SSH_SEGMENT;

// tty management
int ssh_app_cursor_keys(struct ssh_session_t *ss) SSH_SEGMENT; // fixme suck
void ssh_key(struct ssh_session_t *ss, char c) SSH_SEGMENT;
void ssh_keys(struct ssh_session_t *ss, uint8_t *buf, uint16_t bufLen) SSH_SEGMENT;
void ssh_bytes(struct ssh_session_t *ss, uint8_t *buf, uint16_t bufLen) SSH_SEGMENT;
void ssh_bytes_internal(struct ssh_session_t *ss, uint8_t *buf, uint16_t bufLen) SSH_SEGMENT; 
void ssh_receive_bytes(struct ssh_session_t *ss, uint8_t *buf, uint16_t bufLen) SSH_SEGMENT;
void ssh_update(struct ssh_session_t *ss) SSH_SEGMENT;
void ssh_task(struct ssh_session_t *ss) SSH_SEGMENT;

// password
// connection calls request_password
// gui calls use_password
void ssh_request_password(int numAttempts) SSH_SEGMENT;
void ssh_use_password(struct ssh_session_t *ss, char *username, char *password) SSH_SEGMENT;
void ssh_request_passphrase(queue_t *q) SSH_SEGMENT;
Boolean ssh_use_passphrase(struct ssh_session_t *ss, char *username, char *passphrase, MemHandle pubkey) SSH_SEGMENT;
void ssh_request_kbdint(char *name, char *instructions, prompt_t *prompts, int prompt_count) SSH_SEGMENT;
void ssh_use_kbdint(struct ssh_session_t *ss, char **responses) SSH_SEGMENT;

// vt100
void ssh_scroll(struct ssh_session_t *ss, int lines) SSH_SEGMENT;
int ssh_visible_height(struct ssh_session_t *ss) SSH_SEGMENT;
void ssh_activate(struct ssh_session_t *ss) SSH_SEGMENT;
void ssh_deactivate(struct ssh_session_t *ss) SSH_SEGMENT;
void ssh_set_bounds(struct ssh_session_t *ss, RectangleType bounds)SSH_SEGMENT;
void ssh_click(struct ssh_session_t *ss, int x, int y, int clickCount) SSH_SEGMENT;
int ssh_selection_exists(struct ssh_session_t *ss) SSH_SEGMENT;
void ssh_deselect(struct ssh_session_t *ss) SSH_SEGMENT;
void ssh_copy(struct ssh_session_t *ss) SSH_SEGMENT;
void ssh_paste(struct ssh_session_t *ss) SSH_SEGMENT;
void ssh_size(struct ssh_session_t *ss, int *charsWide, int *charsHigh) SSH_SEGMENT;

void ssh_reread_prefs(struct ssh_session_t *ss) SSH_SEGMENT;

#endif
