/**********
 * Copyright (c) 2003-2005 Greg Parker.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY GREG PARKER ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 **********/

#include "includes.h"
#include "ssh/ssh.h"

#include <PalmOSGlue.h>

// #define DEBUG_ARENA
// #define DEBUG_NONARENA

// arena allocator is intended for use if pssh ever supports multiple 
// simultaneous connections. An error in one connection would trigger 
// destruction of its arena during cleanup.
// Currently, arena and non-arena allocators are identical.

void *arena_malloc(size_t s) 
{
    void *p;
    if (s == 0) s = 1; // fixme openssh is expecting fatal for size 0
    p = MemGluePtrNew(s);
    if (p == NULL) {
        debug_printf("%ld bytes", s);
        fatal("arena_malloc: out of memory");
    }
    return p;
}

void arena_free(void *p) 
{
    if (!p) return; // needed by PuTTY?
    MemPtrFree(p);
}

void *arena_calloc(size_t s) 
{
    void *p;
    p = arena_malloc(s);
    memset(p, 0, s);
    return p;
}

void *arena_realloc(void *oldp, size_t newsize)
{
    void *newp;

    newp = arena_malloc(newsize);
    if (!oldp) {
        return newp;
    } else {
        size_t oldsize;
        oldsize = MemPtrSize(oldp);
        memcpy(newp, oldp, MIN(newsize, oldsize));
        arena_free(oldp); // fixme reallocf?
        return newp;
    }
}

char *arena_strdup(const char *s)
{
    size_t len = 1+strlen(s);
    char *news;
    news = arena_malloc(len);
    memcpy(news, s, len);
    return news;
}

