/**********
 * Copyright (c) 2003-2004 Greg Parker.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY GREG PARKER ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 **********/

#include "bn_includes.h"
#include "bn_internal.h"
#include "pealstub.h"
#include "swap.h"

uint32_t BN_is_negative_stub(uint32_t *param);
uint32_t BN_CTX_new_stub(uint32_t *param);
uint32_t BN_CTX_free_stub(uint32_t *param);
uint32_t BN_CTX_start_stub(uint32_t *param);
uint32_t BN_CTX_get_stub(uint32_t *param);
uint32_t BN_CTX_end_stub(uint32_t *param);
uint32_t BN_rand_stub(uint32_t *param);
uint32_t BN_num_bits_stub(uint32_t *param);
uint32_t BN_new_stub(uint32_t *param);
uint32_t BN_clear_free_stub(uint32_t *param);
uint32_t BN_bin2bn_stub(uint32_t *param);
uint32_t BN_bn2bin_stub(uint32_t *param);
uint32_t BN_cmp_stub(uint32_t *param);
uint32_t BN_free_stub(uint32_t *param);
uint32_t BN_is_bit_set_stub(uint32_t *param);
uint32_t BN_mod_exp_mont_stub(uint32_t *param);
uint32_t BN_mod_exp_mont_word_stub(uint32_t *param);
uint32_t BN_bn2hex_stub(uint32_t *param);
uint32_t BN_hex2bn_stub(uint32_t *param);
uint32_t BN_MONT_CTX_new_stub(uint32_t *param);
uint32_t BN_MONT_CTX_free_stub(uint32_t *param);
uint32_t BN_MONT_CTX_set_stub(uint32_t *param);
uint32_t BN_is_zero_stub(uint32_t *param);
uint32_t BN_mod_mul_stub(uint32_t *param);
uint32_t BN_ucmp_stub(uint32_t *param);
uint32_t BN_mod_inverse_stub(uint32_t *param);
uint32_t BN_div_stub(uint32_t *param);
uint32_t BN_add_stub(uint32_t *param);
uint32_t BN_sub_stub(uint32_t *param);
uint32_t BN_rand_range_stub(uint32_t *param);


uint32_t BN_is_negative_stub(uint32_t *param) {
    BIGNUM *a = (BIGNUM *)read32(&param[0]);
    return (uint32_t) BN_is_negative(a);
}

uint32_t BN_CTX_new_stub(uint32_t *param) {
    return (uint32_t) BN_CTX_new();
}

uint32_t BN_CTX_free_stub(uint32_t *param) {
    BN_CTX *ctx = (BN_CTX *)read32(&param[0]);
    BN_CTX_free(ctx);
    return 0;
}

uint32_t BN_CTX_start_stub(uint32_t *param) {
    BN_CTX *ctx = (BN_CTX *)read32(&param[0]);
    BN_CTX_start(ctx);
    return 0;
}

uint32_t BN_CTX_get_stub(uint32_t *param) {
    BN_CTX *ctx = (BN_CTX *)read32(&param[0]);
    return (uint32_t) BN_CTX_get(ctx);
}

uint32_t BN_CTX_end_stub(uint32_t *param) {
    BN_CTX *ctx = (BN_CTX *)read32(&param[0]);
    BN_CTX_end(ctx);
    return 0;
}

uint32_t BN_rand_stub(uint32_t *param) {
    BIGNUM *rnd = (BIGNUM *)read32(&param[0]);
    int bits = (int)read32(&param[1]);
    int top = (int)read32(&param[2]);
    int bottom = (int)read32(&param[3]);
    return (uint32_t) BN_rand(rnd, bits, top, bottom);
}

uint32_t BN_num_bits_stub(uint32_t *param) {
    BIGNUM *a = (BIGNUM *)read32(&param[0]);
    return (uint32_t) BN_num_bits(a);
}

uint32_t BN_new_stub(uint32_t *param) {
    return (uint32_t) BN_new();
}

uint32_t BN_clear_free_stub(uint32_t *param) {
    BIGNUM *a = (BIGNUM *)read32(&param[0]);
    BN_clear_free(a);
    return 0;
}

uint32_t BN_bin2bn_stub(uint32_t *param) {
    unsigned char *s = (unsigned char *)read32(&param[0]);
    int len = (int)read32(&param[1]);
    BIGNUM *ret = (BIGNUM *)read32(&param[2]);
    return (uint32_t) BN_bin2bn(s, len, ret);
}

uint32_t BN_bn2bin_stub(uint32_t *param) {
    BIGNUM *a = (BIGNUM *)read32(&param[0]);
    unsigned char *to = (unsigned char *)read32(&param[1]);
    return (uint32_t) BN_bn2bin(a, to);
}

uint32_t BN_cmp_stub(uint32_t *param) {
    BIGNUM *a = (BIGNUM *)read32(&param[0]);
    BIGNUM *b = (BIGNUM *)read32(&param[1]);
    return (uint32_t) BN_cmp(a, b);
}

uint32_t BN_free_stub(uint32_t *param) {
    BIGNUM *a = (BIGNUM *)read32(&param[0]);
    BN_free(a);
    return 0;
}

uint32_t BN_is_bit_set_stub(uint32_t *param) {
    BIGNUM *a = (BIGNUM *)read32(&param[0]);
    int n = (int)read32(&param[1]);
    return (uint32_t) BN_is_bit_set(a, n);
}

uint32_t BN_mod_exp_mont_stub(uint32_t *param) {
    BIGNUM *r = (BIGNUM *)read32(&param[0]);
    BIGNUM *a = (BIGNUM *)read32(&param[1]);
    BIGNUM *p = (BIGNUM *)read32(&param[2]);
    BIGNUM *m = (BIGNUM *)read32(&param[3]);
    BN_CTX *ctx = (BN_CTX *)read32(&param[4]);
    BN_MONT_CTX *m_ctx = (BN_MONT_CTX *)read32(&param[5]);
    return (uint32_t) BN_mod_exp_mont(r, a, p, m, ctx, m_ctx);
}

uint32_t BN_mod_exp_mont_word_stub(uint32_t *param) {
    BIGNUM *r = (BIGNUM *)read32(&param[0]);
    BN_ULONG a = (BN_ULONG)read32(&param[1]);
    BIGNUM *p = (BIGNUM *)read32(&param[2]);
    BIGNUM *m = (BIGNUM *)read32(&param[3]);
    BN_CTX *ctx = (BN_CTX *)read32(&param[4]);
    BN_MONT_CTX *m_ctx = (BN_MONT_CTX *)read32(&param[5]);
    return (uint32_t) BN_mod_exp_mont_word(r, a, p, m, ctx, m_ctx);
}

uint32_t BN_bn2hex_stub(uint32_t *param) {
    BIGNUM *a = (BIGNUM *)read32(&param[0]);
    return (uint32_t) BN_bn2hex(a);
}

uint32_t BN_hex2bn_stub(uint32_t *param) {
    BIGNUM **a = (BIGNUM **)read32(&param[0]);
    char *str = (char *)read32(&param[1]);
    swap32P(a);
    uint32_t result = (uint32_t) BN_hex2bn(a, str);
    swap32P(a);
    return result;
}

uint32_t BN_MONT_CTX_new_stub(uint32_t *param) {
    return (uint32_t) BN_MONT_CTX_new();
}

uint32_t BN_MONT_CTX_free_stub(uint32_t *param) {
    BN_MONT_CTX *ctx = (BN_MONT_CTX *)read32(&param[0]);
    BN_MONT_CTX_free(ctx);
    return 0;
}

uint32_t BN_MONT_CTX_set_stub(uint32_t *param) {
    BN_MONT_CTX *mont = (BN_MONT_CTX *)read32(&param[0]);
    BIGNUM *mod = (BIGNUM *)read32(&param[1]);
    BN_CTX *ctx = (BN_CTX *)read32(&param[2]);
    return BN_MONT_CTX_set(mont, mod, ctx);
}

uint32_t BN_is_zero_stub(uint32_t *param) {
    BIGNUM *a = (BIGNUM *)read32(&param[0]);
    return (uint32_t) BN_is_zero(a);
}

uint32_t BN_mod_mul_stub(uint32_t *param) {
    BIGNUM *r = (BIGNUM *)read32(&param[0]);
    BIGNUM *a = (BIGNUM *)read32(&param[1]);
    BIGNUM *b = (BIGNUM *)read32(&param[2]);
    BIGNUM *m = (BIGNUM *)read32(&param[3]);
    BN_CTX *ctx = (BN_CTX *)read32(&param[4]);
    return (uint32_t) BN_mod_mul(r, a, b, m, ctx);
}

uint32_t BN_ucmp_stub(uint32_t *param) {
    BIGNUM *a = (BIGNUM *)read32(&param[0]);
    BIGNUM *b = (BIGNUM *)read32(&param[1]);
    return (uint32_t) BN_ucmp(a, b);
}

uint32_t BN_mod_inverse_stub(uint32_t *param) {
    BIGNUM *r = (BIGNUM *)read32(&param[0]);
    BIGNUM *a = (BIGNUM *)read32(&param[1]);
    BIGNUM *n = (BIGNUM *)read32(&param[2]);
    BN_CTX *ctx = (BN_CTX *)read32(&param[3]);
    return (uint32_t) BN_mod_inverse(r, a, n, ctx);
}

uint32_t BN_div_stub(uint32_t *param) {
    BIGNUM *dv = (BIGNUM *)read32(&param[0]);
    BIGNUM *rem = (BIGNUM *)read32(&param[1]);
    BIGNUM *m = (BIGNUM *)read32(&param[2]);
    BIGNUM *d = (BIGNUM *)read32(&param[3]);
    BN_CTX *ctx = (BN_CTX *)read32(&param[4]);
    return (uint32_t) BN_div(dv, rem, m, d, ctx);
}

uint32_t BN_add_stub(uint32_t *param) {
    BIGNUM *r = (BIGNUM *)read32(&param[0]);
    BIGNUM *a = (BIGNUM *)read32(&param[1]);
    BIGNUM *b = (BIGNUM *)read32(&param[2]);
    return (uint32_t) BN_add(r, a, b);
}

uint32_t BN_sub_stub(uint32_t *param) {
    BIGNUM *r = (BIGNUM *)read32(&param[0]);
    BIGNUM *a = (BIGNUM *)read32(&param[1]);
    BIGNUM *b = (BIGNUM *)read32(&param[2]);
    return (uint32_t) BN_sub(r, a, b);
}

uint32_t BN_rand_range_stub(uint32_t *param) {
    BIGNUM *r = (BIGNUM *)read32(&param[0]);
    BIGNUM *range = (BIGNUM *)read32(&param[1]);
    return (uint32_t) BN_rand_range(r, range);
}

