#ifndef SWAP_H
#define SWAP_H

#include <stdint.h>

extern inline uint16_t swap16(uint16_t v);
extern inline uint32_t swap32(uint32_t v);
extern inline void swap16P(const void *p);
extern inline void swap32P(void *p);
#ifdef __PALMTYPES_H__
extern inline void swapRect(const struct RectangleType *r);
#endif

extern inline uint16_t read16(void *p);
extern inline uint32_t read32(void *p);
extern inline void write16(void *p, uint16_t value);
extern inline void write32(void *p, uint32_t value);
#ifdef __PALMTYPES_H__
extern inline RectangleType readRect(void *p);
extern inline void writeRect(void *p, RectangleType r);
#endif

extern inline uint16_t swap16(uint16_t v)
{
    return (((v & 0x00ff) << 8) | 
            ((v & 0xff00) >> 8));
    
}


extern inline uint32_t swap32(uint32_t v)
{
    return (((v & 0x000000ff) << 24) | 
            ((v & 0x0000ff00) <<  8) | 
            ((v & 0x00ff0000) >>  8) | 
            ((v & 0xff000000) >> 24));
}


extern inline void swap16P(const void *p)
{
    *(uint16_t *)p = swap16(*(uint16_t *)p);
}


extern inline void swap32P(void *p)
{
    *(uint32_t *)p = swap32(*(uint32_t *)p);
}


#ifdef __PALMTYPES_H__

// const because most rectangle parameters are const
extern inline void swapRect(const RectangleType *r)
{
    swap16P(&r->topLeft.x);
    swap16P(&r->topLeft.y);
    swap16P(&r->extent.x);
    swap16P(&r->extent.y);
}

#endif


extern inline uint16_t read16(void *p)
{
    uint8_t *c = (uint8_t *)p;
    return (uint16_t)( (c[0] << 8) | 
                       (c[1] << 0) );
}

extern inline uint32_t read32(void *p)
{
    uint8_t *c = (uint8_t *)p;
    return (uint32_t)( (c[0] << 24) | 
                       (c[1] << 16) | 
                       (c[2] <<  8) | 
                       (c[3] <<  0) );
}


extern inline void write16(void *p, uint16_t value)
{
    uint8_t *c = (uint8_t *)p;
    c[0] = value >> 8;
    c[1] = value >> 0;
}


extern inline void write32(void *p, uint32_t value)
{
    uint8_t *c = (uint8_t *)p;
    c[0] = value >> 24;
    c[1] = value >> 16;
    c[2] = value >>  8;
    c[3] = value >>  0;
}


#ifdef __PALMTYPES_H__

extern inline RectangleType readRect(void *p)
{
    RectangleType *r68K = (RectangleType *)p;
    RectangleType r;
    
    r.topLeft.x = read16(&r68K->topLeft.x);
    r.topLeft.y = read16(&r68K->topLeft.y);
    r.extent.x  = read16(&r68K->extent.x);
    r.extent.y  = read16(&r68K->extent.y);

    return r;
}


extern inline void writeRect(void *p, RectangleType r)
{
    RectangleType *r68K = (RectangleType *)p;
    
    write16(&r68K->topLeft.x, r.topLeft.x);
    write16(&r68K->topLeft.y, r.topLeft.y);
    write16(&r68K->extent.x,  r.extent.x);
    write16(&r68K->extent.y,  r.extent.y);
}

#endif


#endif
