/**********
 * Copyright (c) 2003-2004 Greg Parker.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY GREG PARKER ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 **********/

#include "includes.h"
#include "pace.h"

// 68K function addresses (eritten by 68K code)
uintptr_t arena_malloc_68K = 0;
uintptr_t arena_realloc_68K = 0;
uintptr_t arena_calloc_68K = 0;
uintptr_t arena_free_68K = 0;

void *arena_malloc(size_t s) 
{
    PACE_PARAMS = {
        PACE_PARAMS_ADD32(s)
    };

    return (void *)PACE_EXEC_FN(arena_malloc_68K, kPceNativeWantA0);
}

void arena_free(void *p) 
{
    PACE_PARAMS = {
        PACE_PARAMS_ADD32(p)
    };

    PACE_EXEC_FN(arena_free_68K, 0);
}

void *arena_calloc(size_t s) 
{
    PACE_PARAMS = {
        PACE_PARAMS_ADD32(s)
    };

    return (void *)PACE_EXEC_FN(arena_calloc_68K, kPceNativeWantA0);
}

void *arena_realloc(void *oldp, size_t newsize)
{
    PACE_PARAMS = {
        PACE_PARAMS_ADD32(oldp)
        PACE_PARAMS_ADD32(newsize)
    };

    return (void *)PACE_EXEC_FN(arena_realloc_68K, kPceNativeWantA0);
}

char *arena_strdup(const char *s)
{
    size_t len = 1+strlen(s);
    char *news;
    news = arena_malloc(len);
    memcpy(news, s, len);
    return news;
}

