/**********
 * Portions Copyright (c) 2004 Greg Parker.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY GREG PARKER ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 **********/
#ifndef PUTTY_PALMSTUFF_H
#define PUTTY_PALMSTUFF_H

#include <stdint.h>


struct FontSpec {
    uint16_t fontID;
    // maybe more later
};

typedef void *Context; // fixme

/* Multi-click events don't repeat MA_CLICK for each click */
#define MULTICLICK_ONLY_EVENT 1

/* get_clip and write_clip do not use nul-terminated characters */
#define SELECTION_NUL_TERMINATED 0

/* Palm newline is CR */
#define SEL_NL { '\r' }

unsigned long getticks(void);
unsigned long tickspersec(void);
#define GETTICKCOUNT getticks
#define TICKSPERSEC tickspersec()
#define CURSORBLINK (tickspersec() * 0.45)


#define WCHAR wchar_t
#define BYTE uint8_t


#define DEFAULT_CODEPAGE 0 /* fixme CS_ISO8859_1 */
#define CP_UTF8 14238 /* fixme CS_UTF8 */
struct unicode_data;
void init_ucs(struct unicode_data *ucsdata, int font_charset, int vtmode);

#endif
