/**********
 * Copyright (c) 2003-2004 Greg Parker.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY GREG PARKER ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 **********/

#ifndef VT100_H
#define VT100_H

#include "includes.h"

typedef struct display {
    // ALL OF THE VALUES BELOW ARE NATIVE-RESOLUTION
    // gadgetBounds is the bounds of the gadget
    // textBounds is the area inside the gadget that can be occupied by 
    //   terminal text of the corrent font. 
    // gadgetBounds != textBounds if the current font size doesn't evenly 
    //   divide the gadget size
    RectangleType gadgetBounds;
    RectangleType textBounds;
    int font_width;
    int font_height;
    int closeBoxSize;

    int fontPref;
    FontID fontID;
    int inactive; // TRUE if we shouldn't draw anything now

    struct terminal_tag *term;
    struct config_tag *cfg;
    struct ssh_session_t *ss;
} display;

// bounds is STANDARD-RESOLUTION
display *vt100_new(struct ssh_session_t *ss, 
                   RectangleType bounds);

void vt100_free(display *disp);

void vt100_write(display *disp, const char *bytes, size_t len);

void vt100_update(display *disp);

void vt100_task(display *disp);

void vt100_scroll(display *disp, int lines);

void vt100_activate(display *disp);

void vt100_deactivate(display *disp);

// in: bounds (STANDARD-RESOLUTION)
// out: charsWide and charsHigh
void vt100_set_bounds(display *disp, RectangleType bounds);

// x and y are STANDARD-RESOLUTION
// clickCount is 1 or more for mouse down, 0 for mouse up
void vt100_click(display *disp, int x, int y, int clickCount);

void vt100_deselect(display *disp);

void vt100_copy(display *disp);

void vt100_paste(display *disp);

int vt100_selection_exists(display *disp);

// bounds returned is NATIVE-RESOLUTION
void vt100_size(display *disp, int *charsWide, int *charsHigh, RectangleType *bounds);

void vt100_reread_prefs(display *disp);

void vt100_seen_key(display *disp);

int vt100_app_cursor_keys(display *disp); // fixme suck

FontID font_for_screen(int fontPref);

void set_palm_color(int fg_color, int bg_color);

#endif
