/**********
 * Copyright (c) 2003-2004 Greg Parker.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY GREG PARKER ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 **********/

// 68K side of 68K->ARM calls into bignum library

#include "includes.h"
#include "bn.h"
#include "bn_armstubs.h"
#include "armstubs.h"
#include "peal.h"

extern void assert_failed(uint32_t which);


static const char bn_bits[256]={
    0,1,2,2,3,3,3,3,4,4,4,4,4,4,4,4,
    5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
    6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,
    6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,
    7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,
    7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,
    7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,
    7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,
    8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
    8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
    8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
    8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
    8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
    8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
    8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
    8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
};


int BN_is_negative(BIGNUM *a) {
    uint32_t param;
    static void *sym = NULL;
    if (!sym) sym = PealLookupSymbol(arm_module, __FUNCTION__ "_stub");
    if (!sym) fatal("no ARM symbol %s", __FUNCTION__ "_stub");

    param = (uint32_t)a;
    return PealCall(arm_module, sym, &param);
}

BN_CTX *BN_CTX_new(void) {
    static void *sym = NULL;
    if (!sym) sym = PealLookupSymbol(arm_module, __FUNCTION__ "_stub");
    if (!sym) fatal("no ARM symbol %s", __FUNCTION__ "_stub");

    return (BN_CTX *) PealCall(arm_module, sym, NULL);
}

void	BN_CTX_free(BN_CTX *c) {
    uint32_t param;
    static void *sym = NULL;
    if (!sym) sym = PealLookupSymbol(arm_module, __FUNCTION__ "_stub");
    if (!sym) fatal("no ARM symbol %s", __FUNCTION__ "_stub");

    param = (uint32_t)c;
    PealCall(arm_module, sym, &param);
}

void	BN_CTX_start(BN_CTX *ctx) {
    uint32_t param;
    static void *sym = NULL;
    if (!sym) sym = PealLookupSymbol(arm_module, __FUNCTION__ "_stub");
    if (!sym) fatal("no ARM symbol %s", __FUNCTION__ "_stub");

    param = (uint32_t)ctx;
    PealCall(arm_module, sym, &param);
}

BIGNUM *BN_CTX_get(BN_CTX *ctx) {
    uint32_t param;
    static void *sym = NULL;
    if (!sym) sym = PealLookupSymbol(arm_module, __FUNCTION__ "_stub");
    if (!sym) fatal("no ARM symbol %s", __FUNCTION__ "_stub");

    param = (uint32_t)ctx;
    return (BIGNUM *) PealCall(arm_module, sym, &param);
}

void	BN_CTX_end(BN_CTX *ctx) {
    uint32_t param;
    static void *sym = NULL;
    if (!sym) sym = PealLookupSymbol(arm_module, __FUNCTION__ "_stub");
    if (!sym) fatal("no ARM symbol %s", __FUNCTION__ "_stub");

    param = (uint32_t)ctx;
    PealCall(arm_module, sym, &param);
}

int     BN_rand(BIGNUM *rnd, int bits, int top,int bottom) {
    uint32_t param[4];
    static void *sym = NULL;
    if (!sym) sym = PealLookupSymbol(arm_module, __FUNCTION__ "_stub");
    if (!sym) fatal("no ARM symbol %s", __FUNCTION__ "_stub");

    param[0] = (uint32_t)rnd;
    param[1] = (uint32_t)bits;
    param[2] = (uint32_t)top;
    param[3] = (uint32_t)bottom;
    return (int) PealCall(arm_module, sym, param);
}

int	BN_num_bits(const BIGNUM *a) {
    uint32_t param;
    static void *sym = NULL;
    if (!sym) sym = PealLookupSymbol(arm_module, __FUNCTION__ "_stub");
    if (!sym) fatal("no ARM symbol %s", __FUNCTION__ "_stub");

    param = (uint32_t)a;
    return (int) PealCall(arm_module, sym, &param);
}

BIGNUM *BN_new(void) {
    static void *sym = NULL;
    if (!sym) sym = PealLookupSymbol(arm_module, __FUNCTION__ "_stub");
    if (!sym) fatal("no ARM symbol %s", __FUNCTION__ "_stub");

    return (BIGNUM *) PealCall(arm_module, sym, NULL);
}

void	BN_clear_free(BIGNUM *a) {
    uint32_t param;
    static void *sym = NULL;
    if (!sym) sym = PealLookupSymbol(arm_module, __FUNCTION__ "_stub");
    if (!sym) fatal("no ARM symbol %s", __FUNCTION__ "_stub");

    param = (uint32_t)a;
    PealCall(arm_module, sym, &param);
}

BIGNUM *BN_bin2bn(const unsigned char *s,int len,BIGNUM *ret) {
    uint32_t param[3];
    static void *sym = NULL;
    if (!sym) sym = PealLookupSymbol(arm_module, __FUNCTION__ "_stub");
    if (!sym) fatal("no ARM symbol %s", __FUNCTION__ "_stub");

    param[0] = (uint32_t)s;
    param[1] = (uint32_t)len;
    param[2] = (uint32_t)ret;
    return (BIGNUM *) PealCall(arm_module, sym, param);
}

int	BN_bn2bin(const BIGNUM *a, unsigned char *to) {
    uint32_t param[2];
    static void *sym = NULL;
    if (!sym) sym = PealLookupSymbol(arm_module, __FUNCTION__ "_stub");
    if (!sym) fatal("no ARM symbol %s", __FUNCTION__ "_stub");

    param[0] = (uint32_t)a;
    param[1] = (uint32_t)to;
    return (int) PealCall(arm_module, sym, param);
}

int	BN_cmp(const BIGNUM *a, const BIGNUM *b) {
    uint32_t param[2];
    static void *sym = NULL;
    if (!sym) sym = PealLookupSymbol(arm_module, __FUNCTION__ "_stub");
    if (!sym) fatal("no ARM symbol %s", __FUNCTION__ "_stub");

    param[0] = (uint32_t)a;
    param[1] = (uint32_t)b;
    return (int) PealCall(arm_module, sym, param);
}

void	BN_free(BIGNUM *a) {
    uint32_t param;
    static void *sym = NULL;
    if (!sym) sym = PealLookupSymbol(arm_module, __FUNCTION__ "_stub");
    if (!sym) fatal("no ARM symbol %s", __FUNCTION__ "_stub");

    param = (uint32_t)a;
    PealCall(arm_module, sym, &param);
}

int	BN_is_bit_set(const BIGNUM *a, int n) {
    uint32_t param[2];
    static void *sym = NULL;
    if (!sym) sym = PealLookupSymbol(arm_module, __FUNCTION__ "_stub");
    if (!sym) fatal("no ARM symbol %s", __FUNCTION__ "_stub");

    param[0] = (uint32_t)a;
    param[1] = (uint32_t)n;
    return (int) PealCall(arm_module, sym, param);
}

int	BN_mod_exp_mont(BIGNUM *r, const BIGNUM *a, const BIGNUM *p,
                        const BIGNUM *m, BN_CTX *ctx, BN_MONT_CTX *m_ctx) 
{
    uint32_t param[6];
    static void *sym = NULL;
    if (!sym) sym = PealLookupSymbol(arm_module, __FUNCTION__ "_stub");
    if (!sym) fatal("no ARM symbol %s", __FUNCTION__ "_stub");

    param[0] = (uint32_t)r;
    param[1] = (uint32_t)a;
    param[2] = (uint32_t)p;
    param[3] = (uint32_t)m;
    param[4] = (uint32_t)ctx;
    param[5] = (uint32_t)m_ctx;
    return (int) PealCall(arm_module, sym, param);
}

int	BN_mod_exp_mont_word(BIGNUM *r, BN_ULONG a, const BIGNUM *p,
                             const BIGNUM *m, BN_CTX *ctx, BN_MONT_CTX *m_ctx) 
{
    uint32_t param[6];
    static void *sym = NULL;
    if (!sym) sym = PealLookupSymbol(arm_module, __FUNCTION__ "_stub");
    if (!sym) fatal("no ARM symbol %s", __FUNCTION__ "_stub");

    param[0] = (uint32_t)r;
    param[1] = (uint32_t)a;
    param[2] = (uint32_t)p;
    param[3] = (uint32_t)m;
    param[4] = (uint32_t)ctx;
    param[5] = (uint32_t)m_ctx;
    return (int) PealCall(arm_module, sym, param);
}

char * 	BN_bn2hex(const BIGNUM *a) {
    uint32_t param;
    static void *sym = NULL;
    if (!sym) sym = PealLookupSymbol(arm_module, __FUNCTION__ "_stub");
    if (!sym) fatal("no ARM symbol %s", __FUNCTION__ "_stub");

    param = (uint32_t)a;
    return (char *) PealCall(arm_module, sym, &param);
}

uint32_t 	BN_hex2bn(BIGNUM **a, const char *str) {
    uint32_t param[2];
    static void *sym = NULL;
    if (!sym) sym = PealLookupSymbol(arm_module, __FUNCTION__ "_stub");
    if (!sym) fatal("no ARM symbol %s", __FUNCTION__ "_stub");

    param[0] = (uint32_t)a;
    param[1] = (uint32_t)str;
    return (uint32_t) PealCall(arm_module, sym, param);
}

BN_MONT_CTX *BN_MONT_CTX_new(void) {
    static void *sym = NULL;
    if (!sym) sym = PealLookupSymbol(arm_module, __FUNCTION__ "_stub");
    if (!sym) fatal("no ARM symbol %s", __FUNCTION__ "_stub");

    return (BN_MONT_CTX *) PealCall(arm_module, sym, NULL);
}

void BN_MONT_CTX_free(BN_MONT_CTX *mont) {
    uint32_t param;
    static void *sym = NULL;
    if (!sym) sym = PealLookupSymbol(arm_module, __FUNCTION__ "_stub");
    if (!sym) fatal("no ARM symbol %s", __FUNCTION__ "_stub");

    param = (uint32_t)mont;
    PealCall(arm_module, sym, &param);
}

int BN_MONT_CTX_set(BN_MONT_CTX *mont,const BIGNUM *mod,BN_CTX *ctx) {
    uint32_t param[3];
    static void *sym = NULL;
    if (!sym) sym = PealLookupSymbol(arm_module, __FUNCTION__ "_stub");
    if (!sym) fatal("no ARM symbol %s", __FUNCTION__ "_stub");

    param[0] = (uint32_t)mont;
    param[1] = (uint32_t)mod;
    param[2] = (uint32_t)ctx;
    return (int) PealCall(arm_module, sym, param);
}

int BN_is_zero(const BIGNUM *a) {
    uint32_t param;
    static void *sym = NULL;
    if (!sym) sym = PealLookupSymbol(arm_module, __FUNCTION__ "_stub");
    if (!sym) fatal("no ARM symbol %s", __FUNCTION__ "_stub");

    param = (uint32_t)a;
    return (int) PealCall(arm_module, sym, &param);
}

int BN_mod_mul(BIGNUM *r, const BIGNUM *a, const BIGNUM *b, const BIGNUM *m, BN_CTX *ctx) {
    uint32_t param[5];
    static void *sym = NULL;
    if (!sym) sym = PealLookupSymbol(arm_module, __FUNCTION__ "_stub");
    if (!sym) fatal("no ARM symbol %s", __FUNCTION__ "_stub");

    param[0] = (uint32_t)r;
    param[1] = (uint32_t)a;
    param[2] = (uint32_t)b;
    param[3] = (uint32_t)m;
    param[4] = (uint32_t)ctx;
    return (int) PealCall(arm_module, sym, param);
}

int BN_ucmp(const BIGNUM *a, const BIGNUM *b) {
    uint32_t param[2];
    static void *sym = NULL;
    if (!sym) sym = PealLookupSymbol(arm_module, __FUNCTION__ "_stub");
    if (!sym) fatal("no ARM symbol %s", __FUNCTION__ "_stub");

    param[0] = (uint32_t)a;
    param[1] = (uint32_t)b;
    return (uint32_t) PealCall(arm_module, sym, param);
}

BIGNUM *BN_mod_inverse(BIGNUM *ret, const BIGNUM *a, const BIGNUM *n,
                       BN_CTX *ctx)
{
    uint32_t param[4];
    static void *sym = NULL;
    if (!sym) sym = PealLookupSymbol(arm_module, __FUNCTION__ "_stub");
    if (!sym) fatal("no ARM symbol %s", __FUNCTION__ "_stub");

    param[0] = (uint32_t)ret;
    param[1] = (uint32_t)a;
    param[2] = (uint32_t)n;
    param[3] = (uint32_t)ctx;
    return (BIGNUM *) PealCall(arm_module, sym, param);
}

int BN_div(BIGNUM *dv, BIGNUM *rem, const BIGNUM *m, const BIGNUM *d, BN_CTX *ctx) {
    uint32_t param[5];
    static void *sym = NULL;
    if (!sym) sym = PealLookupSymbol(arm_module, __FUNCTION__ "_stub");
    if (!sym) fatal("no ARM symbol %s", __FUNCTION__ "_stub");

    param[0] = (uint32_t)dv;
    param[1] = (uint32_t)rem;
    param[2] = (uint32_t)m;
    param[3] = (uint32_t)d;
    param[4] = (uint32_t)ctx;
    return (int) PealCall(arm_module, sym, param);
}

int BN_add(BIGNUM *r, const BIGNUM *a, const BIGNUM *b) {
    uint32_t param[3];
    static void *sym = NULL;
    if (!sym) sym = PealLookupSymbol(arm_module, __FUNCTION__ "_stub");
    if (!sym) fatal("no ARM symbol %s", __FUNCTION__ "_stub");

    param[0] = (uint32_t)r;
    param[1] = (uint32_t)a;
    param[2] = (uint32_t)b;
    return (int) PealCall(arm_module, sym, param);
}

int BN_sub(BIGNUM *r, const BIGNUM *a, const BIGNUM *b) {
    uint32_t param[3];
    static void *sym = NULL;
    if (!sym) sym = PealLookupSymbol(arm_module, __FUNCTION__ "_stub");
    if (!sym) fatal("no ARM symbol %s", __FUNCTION__ "_stub");

    param[0] = (uint32_t)r;
    param[1] = (uint32_t)a;
    param[2] = (uint32_t)b;
    return (int) PealCall(arm_module, sym, param);
}

int BN_rand_range(BIGNUM *r, BIGNUM *range) {
    uint32_t param[2];
    static void *sym = NULL;
    if (!sym) sym = PealLookupSymbol(arm_module, __FUNCTION__ "_stub");
    if (!sym) fatal("no ARM symbol %s", __FUNCTION__ "_stub");

    param[0] = (uint32_t)r;
    param[1] = (uint32_t)range;
    return (int) PealCall(arm_module, sym, param);
}
