/**********
 * Copyright (c) 2003-2004 Greg Parker.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY GREG PARKER ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 **********/

/* Assorted OpenSSL definitions */

#ifndef CRYPTLIB_H
#define CRYPTLIB_H

#include "includes.h"

#include "xmalloc.h"

#define OPENSSL_VERSION_NUMBER 0x0090703fL

/* size of string representations */
#define DECIMAL_SIZE(type)      ((sizeof(type)*8+2)/3+1)
#define HEX_SIZE(type)          (sizeof(type)*2)

#define DHerr(a,b) fatal("dh error " #a " " #b)
#define EVPerr(a,b) fatal("EVP error " #a " " #b)
#define DSAerr(a,b) fatal("DSA error " #a " " #b)
#define RSAerr(a,b) fatal("RSA error " #a " " #b)

#define OPENSSL_malloc(p) arena_malloc(p)
#define OPENSSL_free(p) arena_free(p)
#define OPENSSL_assert(a) do { if (!(a)) fatal("OpenSSL error"); } while (0)

// in mem_clr.c
extern void OPENSSL_cleanse(void *ptr, size_t len);

#define OPENSSL_NO_BIO
#define OPENSSL_NO_FP_API
#define OPENSSL_NO_ENGINE

#define OPENSSL_NO_MD2
#define OPENSSL_NO_MD4
#define OPENSSL_NO_RIPEMD
#define OPENSSL_NO_RC4
#define OPENSSL_NO_RC2
#define OPENSSL_NO_RC5
#define OPENSSL_NO_BF
#define OPENSSL_NO_CAST
#define OPENSSL_NO_IDEA
#define OPENSSL_NO_MDC2

#define OPENSSL_DISABLE_OLD_DES_SUPPORT
#define OPENSSL_NO_SHA0

#define OPENSSL_VERSION_PTEXT /**/

#define STACK_OF(a) void

#define DES_LONG uint32_t

#define ASN1_TYPE void
#define ASN1_OBJECT void

#define ENGINE void
typedef struct evp_cipher_st EVP_CIPHER;
typedef struct evp_cipher_ctx_st EVP_CIPHER_CTX;
typedef struct env_md_st EVP_MD;
typedef struct env_md_ctx_st EVP_MD_CTX;
typedef struct evp_pkey_st EVP_PKEY;



/* Macros to allow global variables to be reached through function calls when
   required (if a shared library version requvres it, for example.
   The way it's done allows definitions like this:

        // in foobar.c
        OPENSSL_IMPLEMENT_GLOBAL(int,foobar) = 0;
        // in foobar.h
        OPENSSL_DECLARE_GLOBAL(int,foobar);
        #define foobar OPENSSL_GLOBAL_REF(foobar)
*/
#ifdef OPENSSL_EXPORT_VAR_AS_FUNCTION
# define OPENSSL_IMPLEMENT_GLOBAL(type,name) static type _hide_##name; \
        type *_shadow_##name(void) { return &_hide_##name; } \
        static type _hide_##name
# define OPENSSL_DECLARE_GLOBAL(type,name) type *_shadow_##name(void)
# define OPENSSL_GLOBAL_REF(name) (*(_shadow_##name()))
#else
# define OPENSSL_IMPLEMENT_GLOBAL(type,name) OPENSSL_GLOBAL type _shadow_##name
# define OPENSSL_DECLARE_GLOBAL(type,name) OPENSSL_EXPORT type _shadow_##name
# define OPENSSL_GLOBAL_REF(name) _shadow_##name
#endif

#define OPENSSL_EXPORT extern
#define OPENSSL_IMPORT extern
#define OPENSSL_GLOBAL
#define OPENSSL_EXTERN OPENSSL_IMPORT

#endif
