/**********
 * Copyright (c) 2003-2004 Greg Parker.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY GREG PARKER ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 **********/

#ifndef CONNECTIONLIST_H
#define CONNECTIONLIST_H

#include "includes.h"
#include "data/recordlist.h"


Boolean ConnectionListInit(void) CONNECTIONLIST_SEGMENT;
void ConnectionListFree(void) CONNECTIONLIST_SEGMENT;

void ConnectionListUpdate(void) CONNECTIONLIST_SEGMENT;
Boolean ConnectionListHandleEvent(EventPtr event) CONNECTIONLIST_SEGMENT;

UInt16 ConnectionListSelectedIndex(void) CONNECTIONLIST_SEGMENT;
void ConnectionListSetSelectedIndex(UInt16 index) CONNECTIONLIST_SEGMENT;
void ConnectionListClearSelection(void) CONNECTIONLIST_SEGMENT;

MemHandle ConnectionListReadSelectedRecord(char **hostname, char **portname, char **username) CONNECTIONLIST_SEGMENT;
Boolean ConnectionListWriteSelectedRecord(FieldPtr hostFld, FieldPtr portFld, FieldPtr userFld)CONNECTIONLIST_SEGMENT;
void ConnectionListDeleteSelectedRecord(void) CONNECTIONLIST_SEGMENT;

#endif
