/**********
 * Copyright (c) 2003-2004 Greg Parker.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY GREG PARKER ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 **********/

// recordlist.h
// A database, a table, and a scroll bar.


#ifndef RECORDLIST_H
#define RECORDLIST_H

#include "includes.h"

#define noRecord ((UInt16)0xffff)

typedef struct RecordList RecordList;

typedef void (*RecordListDrawProc)(MemPtr record, UInt16 index, 
                                   RectanglePtr bounds);

RecordList *RecordListNew(DmOpenRef newDB, UInt16 newFormID, 
                          UInt16 newTableID, UInt16 newScrollbarID, 
                          RecordListDrawProc newDraw) RECORDLIST_SEGMENT;
void RecordListFree(RecordList *rl) RECORDLIST_SEGMENT;
void RecordListUpdate(RecordList *rl) RECORDLIST_SEGMENT;
UInt16 RecordListCount(RecordList *rl) RECORDLIST_SEGMENT;

UInt16 RecordListSelectedIndex(RecordList *rl) RECORDLIST_SEGMENT;
void RecordListSetSelectedIndex(RecordList *rl, UInt16 index) RECORDLIST_SEGMENT;
void RecordListClearSelection(RecordList *rl) RECORDLIST_SEGMENT;

MemHandle RecordListQuerySelectedRecord(RecordList *rl) RECORDLIST_SEGMENT;
MemHandle RecordListGetSelectedRecord(RecordList *rl, UInt32 createWithSize) RECORDLIST_SEGMENT;
void RecordListReleaseRecord(RecordList *rl, MemHandle recordH, Boolean dirty) RECORDLIST_SEGMENT;
void RecordListDeleteSelectedRecord(RecordList *rl) RECORDLIST_SEGMENT;

MemHandle RecordListQueryIndexedRecord(RecordList *rl, UInt16 index) RECORDLIST_SEGMENT;
MemHandle RecordListGetIndexedRecord(RecordList *rl, UInt16 index) RECORDLIST_SEGMENT;
void RecordListDeleteIndexedRecord(RecordList *rl, UInt16 index) RECORDLIST_SEGMENT;

Boolean RecordListHandleEvent(RecordList *rl, EventPtr event) RECORDLIST_SEGMENT;

#endif
