/**********
 * Copyright (c) 2003-2005 Greg Parker.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY GREG PARKER ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 **********/

#include "includes.h"
#include "formutils.h"
#include "forms/resize.h"
#include "rsrc/rsrc.h"

#include "about.h"


Boolean AboutFormHandleEvent(EventPtr e)
{
    FormPtr frmP = FrmGetActiveForm();

    if (ResizeHandleEvent(e)) return true;

    switch (e->eType) {
    case frmOpenEvent:
        FrmDrawForm(frmP);
        return true;

    case ctlSelectEvent:
        if (e->data.ctlSelect.controlID == AboutFormOKButtonID) {
            FrmReturnToForm(0);
            return true;
        }
        return false;

    default:
        return false;
    }
}


#define credits \
    "pssh is brought to you by:\n" \
    "Greg Parker: www.sealiesoftware.com\n\n" \
    "Eric Young and the OpenSSL team: www.OpenSSL.org\n\n" \
    "Tatu Ylonen, Markus Friedl, Niels Provos, and the OpenSSH team: www.OpenSSH.org\n\n" \
    "Simon Tatham and the PuTTY team: www.chiark.greenend.org.uk/~sgtatham/putty/\n\n" \
    "Aaron Gifford: www.aarongifford.com\n\n" \
    "Alex Pruss: sf.net/projects/palmresize\n\n" \
    "Lauri Aarnio: www.nixu.fi/~lauri/\n\n" \
    "Walter Francis, Ton van Overbeek, David Carrel, Brian Wingerter, David Nolan, Jason Perry, Dan Vollmer, Olaf Kolling, Chris Weiss, Alexander Burke, Andreas Amann, Duncan Hudson, Jon Winters, Brian Parker, Ronny Hippler, Guy Davies, Thomas Arendsen Hein, Stefan Braunstein, Michael Bongartz, Olaf Ippisch, Michael Frotscher, Daniel Arvesen, and everyone else who has reported bugs and tested bug fixes\n\n" \
    "Treo 650 RNG customizations by Daniel Grobe Sachs <dgsachs@nekito.net>\n" \
    "Treo 650 Keyboard (ALT) customizations by Jeffrey Hutzelman\n" \
    "Treo 650 features combined by Alejandro Sedeno\n"\
    "---\n\n" \
    "This product includes software developed by the OpenSSL Project for use in the OpenSSL Toolkit. (http://www.OpenSSL.org/)\n" \
    "This product contains cryptographic software written by Eric Young (eay@cryptsoft.com)"


Boolean CreditsFormHandleEvent(EventPtr e)
{
    FormPtr frmP = FrmGetActiveForm();

    if (ResizeHandleEvent(e)) return true;

    switch (e->eType) {
    case frmOpenEvent:
        PrvSetFieldToValueByID(CreditsFormFieldID, credits);
        PrvUpdateScrollbarForField(CreditsFormFieldID, 
                                   CreditsFormScrollbarID);
        FrmDrawForm(frmP);
        return true;

    case sclRepeatEvent:
        if (e->data.sclRepeat.scrollBarID == CreditsFormScrollbarID) {
            PrvScrollField(CreditsFormFieldID, e);
        }
        return false;

    case ctlSelectEvent:
        if (e->data.ctlSelect.controlID == CreditsFormOKButtonID) {
            PrvSetFieldToValueByID(CreditsFormFieldID, "");
            FrmReturnToForm(0);
            return true;
        }
        return false;

    default:
        return false;
    }
}


static char *BannerText = NULL;
static int BannerDone;

void Banner(char *text)
{
    int i;
    int shift = 0;
    int sawNewline = false;
    Err err;
    EventType event;

    // Reformat the banner:
    // elide '\r'
    // fixme elide lone '\n' or something

    shift = 0;
    for (i = 0; text[i]; i++) {
        if (text[i] == '\r') {
            shift++;
        } else if (text[i] == '\n'  &&  !sawNewline) {
            text[i-shift] = ' ';
            sawNewline = true;
        } else {
            sawNewline = (text[i] == '\n');
            text[i-shift] = text[i];
        }
    }
    text[i-shift] = '\0';
    
    BannerText = text;
    BannerDone = false;
    
    FrmPopupForm(BannerFormID);

    // Don't return to main loop, because we can't handle network traffic 
    // until the banner is dismissed.
    // fixme suck
    
    do {
        EvtGetEvent(&event, -1);
        if (!SysHandleEvent(&event)) {
            if (!MenuHandleEvent(NULL, &event, &err)) {
                if (!ApplicationHandleEvent(&event)) {
                    FrmDispatchEvent(&event);
                }
            }
        }
    } while (event.eType != appStopEvent  &&  !BannerDone);
}


Boolean BannerFormHandleEvent(EventPtr e)
{
    FormPtr frmP = FrmGetActiveForm();

    if (ResizeHandleEvent(e)) return true;

    switch (e->eType) {
    case frmOpenEvent:
        PrvSetFieldToValueByID(BannerFormFieldID, BannerText);
        PrvUpdateScrollbarForField(BannerFormFieldID, 
                                   BannerFormScrollbarID);
        FrmDrawForm(frmP);

        // fixme resize form based on length of banner text

        return true;

    case sclRepeatEvent:
        if (e->data.sclRepeat.scrollBarID == BannerFormScrollbarID) {
            PrvScrollField(BannerFormFieldID, e);
        }
        return false;

    case ctlSelectEvent:
        if (e->data.ctlSelect.controlID == BannerFormOKButtonID) {
            PrvSetFieldToValueByID(BannerFormFieldID, "");
            BannerDone = true;
            FrmReturnToForm(0);
            return true;
        }
        return false;

    default:
        return false;
    }
}
