/**********
 * Copyright (c) 2003-2005 Greg Parker.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY GREG PARKER ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 **********/

#include "includes.h"
#include "formutils.h"
#include "forms/resize.h"
#include "data/hostkeys.h"
#include "rsrc/rsrc.h"

#include "hostkeysform.h"


Boolean HostKeysFormHandleEvent(EventPtr e)
{
    FormPtr frmP = FrmGetActiveForm();

    if (ResizeHandleEvent(e)) return true;
    if (HostKeysHandleEvent(e)) return true;

    switch (e->eType) {
    case frmOpenEvent:
        HostKeysUpdate();
        FrmDrawForm(frmP);
        return true;

    case ctlSelectEvent:
        switch (e->data.ctlSelect.controlID) {

        case HostKeysFormOKButtonID:
            FrmReturnToForm(0);
            break;

        case HostKeysFormDetailsButtonID:
            if (HostKeysSelectedIndex() != noRecord) {
                FrmPopupForm(HostKeyDetailsFormID);
            }
            break;

        default: 
            break;

        }
        return false;

    case frmCloseEvent:
        return false;

    default: 
        return false;
    }
}


void HostKeysFormResize(FormPtr frmP, Int16 dh, Int16 dv)
{
    static Int16 height = -1;
    PrvResizeTableAndScrollbar(frmP, dh, dv, 0, &height, 
                               FrmGetObjectIndex(frmP, HostKeysFormKeyTableID),
                               FrmGetObjectIndex(frmP, HostKeysFormKeyScrollbarID));

    HostKeysUpdate();
}

