/**********
 * Copyright (c) 2004-2005 Greg Parker.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY GREG PARKER ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 **********/

#include "includes.h"
#include "formutils.h"
#include "data/prefs.h"
#include "ssh/ssh.h"
#include "rsrc/rsrc.h"
#include "forms/resize.h"

#include "keyboardprefsform.h"


static void LoadKeyboardPrefsForm(void) FORMS_SEGMENT;
static void SaveKeyboardPrefsForm(void) FORMS_SEGMENT;

static void LoadKeyboardPrefsForm(void)
{
    uint32_t value;

    // backspace behavior
    value = PrefsGetInt(prefBackspace, defaultBackspace);
    PrvSetControlValue(KeyboardPrefsFormBackspaceDELCheckboxID, 
                       value == backspaceDEL ? 1 : 0);
    PrvSetControlValue(KeyboardPrefsFormBackspaceBSCheckboxID,  
                       value == backspaceBS ? 1 : 0);

    // backquote behavior
    value = PrefsGetInt(prefBackquote, defaultBackquote);
    PrvSetControlValue(KeyboardPrefsFormBackquoteNormalCheckboxID, 
                       value == backquoteNormal ? 1 : 0);
    PrvSetControlValue(KeyboardPrefsFormBackquoteESCCheckboxID,  
                       value == backquoteESC ? 1 : 0);
}


static void SaveKeyboardPrefsForm(void)
{
    uint32_t value;

    // backspace behavior
    value = PrefsGetInt(prefBackspace, defaultBackspace);
    if (PrvGetControlValue(KeyboardPrefsFormBackspaceDELCheckboxID) && value != backspaceDEL) {
        PrefsPutInt(prefBackspace, backspaceDEL);
    } else if (PrvGetControlValue(KeyboardPrefsFormBackspaceBSCheckboxID) && value != backspaceBS) {
        PrefsPutInt(prefBackspace, backspaceBS);
    }

    // backquote behavior
    value = PrefsGetInt(prefBackquote, defaultBackquote);
    if (PrvGetControlValue(KeyboardPrefsFormBackquoteNormalCheckboxID) && value != backquoteNormal) {
        PrefsPutInt(prefBackquote, backquoteNormal);
    } else if (PrvGetControlValue(KeyboardPrefsFormBackquoteESCCheckboxID) && value != backquoteESC) {
        PrefsPutInt(prefBackquote, backquoteESC);
    }
}


Boolean KeyboardPrefsFormHandleEvent(EventPtr e)
{
    FormPtr frmP = FrmGetActiveForm();

    if (ResizeHandleEvent(e)) return true;

    switch (e->eType) {
    case frmOpenEvent:
        LoadKeyboardPrefsForm();
        FrmDrawForm(frmP);
        return true;

    case ctlSelectEvent:
        switch (e->data.ctlSelect.controlID) {
        case KeyboardPrefsFormOKButtonID:
            // save values; leave form
            SaveKeyboardPrefsForm();
            FrmReturnToForm(0);
            return true;

        case KeyboardPrefsFormCancelButtonID:
            // DON'T save values; leave form
            FrmReturnToForm(0);
            return true;

        default:
            return false;
        }

    case frmCloseEvent:
        return false;

    default:
        return false;
    }
}

