/**********
 * Copyright (c) 2003-2004 Greg Parker.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY GREG PARKER ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 **********/

#include "includes.h"
#include "pce.h"
#include "armstubs.h"

#include "peal.h"

#include "ssh/ssh.h"
#include "data/prefs.h"

PealModule *arm_module = NULL;

int init_arm(void)
{
    if (!arm_module) {
        uintptr_t *addr;
        // Initialize ARM code resource
        arm_module = PealLoadFromResources('armc', 1000);
        if (!arm_module) return 0;

        // store some 68K function pointers in ARM globals

#define SAVE(fn) \
        addr = (uintptr_t *)PealLookupSymbol(arm_module, #fn "_68K"); \
        if (!addr) fatal("no ARM symbol %s", #fn "_68K"); \
        *addr = ByteSwap32(&fn)

        SAVE(arena_malloc);
        SAVE(arena_free);
        SAVE(arena_calloc);
        SAVE(arena_realloc);

        SAVE(PrefsInit);
        SAVE(PrefsGetInt);
        SAVE(PrefsGetString);
        SAVE(PrefsPutInt);
        SAVE(PrefsPutString);

        SAVE(assert_failed);
        SAVE(fatal);
        SAVE(ssh_bytes);
    }
    return 1;
}
