/**********
 * Copyright (c) 2003-2005 Greg Parker.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY GREG PARKER ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 **********/

#ifndef FORMUTILS_H
#define FORMUTILS_H

#include "includes.h"

void *PrvGetObjectByID(UInt16 id) FORMS_SEGMENT;
UInt16 PrvGetObjectIndexByID(UInt16 id) FORMS_SEGMENT;
Err PrvRemoveObjectByID(UInt16 id) FORMS_SEGMENT;
void PrvShowObjectByID(UInt16 id) FORMS_SEGMENT;
void PrvHideObjectByID(UInt16 id) FORMS_SEGMENT;
void PrvSetObjectVisibilityByID(UInt16 id, Boolean show) FORMS_SEGMENT;
Boolean PrvObjectVisibleByID(UInt16 id) FORMS_SEGMENT;
void PrvGetObjectBoundsByID(UInt16 id, RectangleType *bounds) FORMS_SEGMENT;
void PrvSetObjectBoundsByID(UInt16 id, const RectangleType *bounds) FORMS_SEGMENT;
void PrvSetObjectHeightByID(UInt16 id, Coord height) FORMS_SEGMENT;

void PrvSetFocusByID(UInt16 id) FORMS_SEGMENT;
void PrvReallySetFocus(FormPtr frmP, EventPtr e) FORMS_SEGMENT;
Int16 PrvGetControlValue(UInt16 id) FORMS_SEGMENT;
void PrvSetControlValue(UInt16 id, Int16 value) FORMS_SEGMENT;
const char *PrvGetControlLabel(UInt16 id) FORMS_SEGMENT;
void PrvSetControlLabel(UInt16 id, const char *label) FORMS_SEGMENT;
void PrvSetControlEnabled(UInt16 id, Boolean usable) FORMS_SEGMENT;
Boolean PrvGetControlEnabled(UInt16 id) FORMS_SEGMENT;
void PrvSetControlGraphics(UInt16 id, UInt16 bitmapID, UInt16 selectedBitmapID) FORMS_SEGMENT;
void PrvDrawControl(UInt16 id) FORMS_SEGMENT;

void PrvCopyFieldContents(UInt16 id, char *dst) FORMS_SEGMENT;
Err PrvStoreFieldToRecord(FieldPtr fld, void *recordP, UInt32 *offset) FORMS_SEGMENT;
Boolean PrvSetFieldToValue(FieldPtr fld, char *str) FORMS_SEGMENT;
Boolean PrvSetFieldToValueByID(UInt16 id, char *str) FORMS_SEGMENT;
void PrvFieldSelectAll(UInt16 id) FORMS_SEGMENT;

void PrvScrollField(UInt16 fldID, EventPtr e) FORMS_SEGMENT;
void PrvUpdateScrollbarForField(UInt16 fldID, UInt16 sclID) FORMS_SEGMENT;

void NetworkError(char *msg, Err err) FORMS_SEGMENT;

void PrvResizeTableAndScrollbar(FormPtr frmP, Int16 dh, Int16 dv, 
                                Int16 columnIndex, Int16 *realExtent, 
                                UInt16 tableIndex, UInt16 scrollbarIndex) FORMS_SEGMENT;
void PrvResizeFieldAndScrollbar(FormPtr frmP, Int16 dh, Int16 dv, 
                                UInt16 tableIndex, UInt16 scrollbarIndex) FORMS_SEGMENT;
void PrvMoveObject(FormPtr frmP, UInt16 id, Int16 dh, Int16 dv) FORMS_SEGMENT;

#endif
